/***************************************************************************
                            kde_KFontCombo.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFONTCOMBO
#define KDE_KFONTCOMBO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A combobox that lists the available fonts.

 The items are painted using the respective font itself, so the user
 can easily choose a font based on its look. This can be turned off
 globally if the user wishes so.

 @author Malte Starostik <malte@kde.org>

 @version $Id: kde_KFontCombo.h,v 1.4 2002/11/25 12:24:34 rdale Exp $
 
 @short A combobox to choose a font.
*/

/** *
 Constructor

*/
kde_KFontCombo * kde_new_KFontCombo(qt_QWidget * parent, char* name);

/** *
 Constructor that takes an already initialzed font list

*/
kde_KFontCombo * kde_new_KFontCombo1(qt_QStringList* fonts, qt_QWidget * parent, char* name);

/** *
 Destructor
     
*/
void kde_del_KFontCombo( kde_KFontCombo* p );

/** *
 Sets the font list.

*/
void kde_KFontCombo_setFonts(kde_KFontCombo* instPointer,qt_QStringList* fonts);

/** *
 Sets the currently selected font.

*/
void kde_KFontCombo_setCurrentFont(kde_KFontCombo* instPointer,qt_QString * family);

/** *

*/
qt_QString * kde_KFontCombo_currentFont(kde_KFontCombo* instPointer);

/** *
 Sets the listed fonts to bold or normal.

*/
void kde_KFontCombo_setBold(kde_KFontCombo* instPointer,int bold);

/** *
 Returns the current bold status.

*/
int kde_KFontCombo_bold(kde_KFontCombo* instPointer);

/** *
 Sets the listed fonts to italic or regular.

*/
void kde_KFontCombo_setItalic(kde_KFontCombo* instPointer,int bold);

/** *
 Returns the current italic status

*/
int kde_KFontCombo_italic(kde_KFontCombo* instPointer);

/** *
 Sets the listed fonts to underlined or not underlined

*/
void kde_KFontCombo_setUnderline(kde_KFontCombo* instPointer,int bold);

/** *
 Returns the current underline status

*/
int kde_KFontCombo_underline(kde_KFontCombo* instPointer);

/** *
 Sets the listed fonts to striked out or not

*/
void kde_KFontCombo_setStrikeOut(kde_KFontCombo* instPointer,int bold);

/** *
 Returns the current strike out status

*/
int kde_KFontCombo_strikeOut(kde_KFontCombo* instPointer);

/** *
 Sets the listed fonts' size

*/
void kde_KFontCombo_setSize(kde_KFontCombo* instPointer,int size);

/** *
 Returns the current font size

*/
int kde_KFontCombo_size(kde_KFontCombo* instPointer);
void kde_KFontCombo_setCurrentItem(kde_KFontCombo* instPointer,int i);

/** *
 Returns the user's setting of whether the items should be painted
 in the respective fonts or not

*/
int kde_KFontCombo_displayFonts( );

/** *
 Updated the combo's @ref listBox() to reflect changes made to the
 fonts' attributed
     
*/
void kde_KFontCombo_updateFonts(kde_KFontCombo* instPointer);
void kde_KFontCombo_virtual_hook(kde_KFontCombo* instPointer,int identifier, void* data);

#endif
