#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "listwindow.h"
#include "v7send.h"
#include "v7snac13.h"
#include "visible.h"
#include "groups.h"

#include <gtk/gtk.h>
#include <string.h>

static void modify_visible_list( GtkWidget *widget, gpointer data );

static gboolean is_visible (CONTACT_PTR contact);

gboolean is_visible (CONTACT_PTR contact)
{
	return (contact ? contact->vis_list : FALSE);
}

void visible_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("Visible List"),
			_("Drag the users you wish to add to your\n"
			  "visible list into this window, and then click\n"
			  "the \"Ok\" button below."),
			GTK_STOCK_OK, NULL,
			G_CALLBACK (modify_visible_list),
			is_visible
		);
		gtk_widget_show_all( dlg );
		g_object_add_weak_pointer (G_OBJECT (dlg), (gpointer *)&dlg);
	} else {
		gtk_window_present (GTK_WINDOW (dlg));
	}
}

void modify_visible_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_visible_list\n" );
#endif

	contact = Contacts;
	while( contact != NULL ) {
	  if (kontakt->vis_list == FALSE) {
	    for( cx = 0; cx < clist->rows; cx ++ ) {
	      gtk_clist_get_text( clist, cx, 0, &uin );
	      if( !strcmp (uin, kontakt->uin) ) {
		v7_visible (mainconnection, kontakt->uin,
			    kontakt->vislist_uid=contact_gen_uid (),
			    TRUE); /* add */ 
		kontakt->vis_list = TRUE;
		
		if (kontakt->invis_list == TRUE) {
		  v7_invisible (mainconnection, kontakt->uin, 
				kontakt->invlist_uid, FALSE); /* remove */
		  kontakt->invlist_uid = 0;
		  kontakt->invis_list = FALSE;
		    
		}                                
	      } 
	    
	    }
	  } else {
	    gboolean isok = FALSE;
	    for( cx = 0; cx < clist->rows; cx ++ ) {
	      gtk_clist_get_text( clist, cx, 0, &uin );
	      if( !strcmp (uin, kontakt->uin) ) {
		isok = TRUE;
		break;
	      }
	    }
	    if (!isok) {
	      v7_visible (mainconnection, kontakt->uin, kontakt->vislist_uid,
			  FALSE); /* remove */
	      kontakt->vislist_uid = 0;
	      kontakt->vis_list = FALSE;
	    }
	  }
	  contact = contact->next;

	}
	Save_RC();
}
