#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "util.h"
#include "icons.h"
#include "tray.h"
#include "eggtrayicon.h"
#include "msg.h"
#include "showlist.h"

#include <gtk/gtk.h>

EggTrayIcon *tray_icon;
GtkWidget *tray_icon_image;
GtkTooltips *tray_icon_tooltip;

gboolean
tray_clicked (GtkWidget *event_box, GdkEventButton *event, gpointer data);
gboolean
tray_menu (GtkWidget *event_box, GdkEventButton *event, gpointer data);

void tray_destroyed(GtkObject *object, gpointer data);

gboolean tray_init (void)
{
	GtkWidget *eventbox;

	tray_icon = egg_tray_icon_new ("GnomeICU");
	tray_icon_image = gtk_image_new_from_pixbuf (get_pixbuf_for_status (Current_Status));
	gtk_widget_show (tray_icon_image);

	eventbox = gtk_event_box_new ();
	gtk_widget_show (eventbox);
	gtk_container_add (GTK_CONTAINER (eventbox), tray_icon_image);
	gtk_container_add (GTK_CONTAINER (tray_icon), eventbox);

	g_signal_connect (G_OBJECT (eventbox), "button_press_event",
	                  G_CALLBACK (tray_clicked), NULL );

	g_signal_connect (G_OBJECT(tray_icon), "destroy",
			  G_CALLBACK (tray_destroyed), NULL);

	gtk_widget_show (GTK_WIDGET (tray_icon));

	tray_icon_tooltip = gtk_tooltips_new ();

	return FALSE;
}

void tray_update (gboolean flash)
{
	GSList *contact;
	int num_messages = 0;
	gchar *nextmsg = NULL;
	gint type = 0;
	gchar *tooltips_str;

	if (!tray_icon)
	  return;

	contact = Contacts;

	while( contact != NULL )
	{
		guchar len = g_slist_length( kontakt->stored_messages );
		if( len ) {
			if( nextmsg == NULL ) {
				nextmsg = g_strdup_printf( _("Next message from %s"), kontakt->nick );
				type = ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type;
			}
			num_messages += len;
		}
		contact = contact->next;
	}

	if( num_messages ) {
		if( flash )
			gtk_image_set_from_pixbuf (GTK_IMAGE(tray_icon_image),
			                get_pixbuf_for_message( type ));
		else
			gtk_image_set_from_pixbuf (GTK_IMAGE(tray_icon_image),
		       	                icon_blank_pixbuf );
	} else {
		gtk_image_set_from_pixbuf (GTK_IMAGE (tray_icon_image),
					   get_pixbuf_for_status (Current_Status));
	}
	gtk_widget_show (tray_icon_image);

	if (nextmsg != NULL)
	  tooltips_str = g_strdup_printf( _("%s\n%d %s\n%d %s\n%s"),
					  get_status_str (Current_Status),
					  gnomeicu_tree_online_contacts(),
					  gnomeicu_tree_online_contacts() ? 
					  _("contacts online"):
					  _("contact online"),
					  num_messages, (num_messages > 1) ?
					  _("new messages"):_("new message"),
					  nextmsg );
	else
	  tooltips_str = g_strdup_printf(_("%s\n%d %s"),
					 get_status_str (Current_Status),
					 gnomeicu_tree_online_contacts(),
					 gnomeicu_tree_online_contacts() ? 
					 _("contacts online"):
					 _("contact online"));
	

	gtk_tooltips_set_tip (tray_icon_tooltip,
	                      GTK_WIDGET (tray_icon),
	                      tooltips_str,
	                      NULL);
	g_free(tooltips_str);
}

gboolean
tray_clicked (GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
	GSList *contact;
	GSList *found_contact = NULL;
	static int window_x = -1;
	static int window_y = -1;

	contact = Contacts;
	while( contact != NULL )
	{
		guchar len = g_slist_length( kontakt->stored_messages );
		if( len )
		{
			found_contact = contact;
			break;
		}
		contact = contact->next;
	}

	if (event->button == 1 && event->type == GDK_2BUTTON_PRESS) {
		if( found_contact ) {
			show_contact_message (found_contact);
		} else {
			if (GTK_WIDGET_VISIBLE (app)) {
				gtk_window_get_position (GTK_WINDOW (app),
				                         &window_x, &window_y);
				gtk_widget_hide (app);
			} else {
				if (window_x >= 0 && window_y >= 0)
				{
					gtk_window_move (GTK_WINDOW (app),
					                 window_x,
					                 window_y);
				}
				gtk_window_present (GTK_WINDOW(app));
			}
		}
		return TRUE;
	} else if (event->button == 3) {
		return tray_menu (event_box, event, data);
	}

	return FALSE;
}

gboolean
tray_menu (GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	GtkWidget *status_menu;
	GtkWidget *item, *image;

#ifdef TRACE_FUNCTION
	g_print( "tray_menu\n" );
#endif
	status_menu = gtk_menu_new();

	item = gtk_image_menu_item_new_with_label (_("Online"));
	image = gtk_image_new_from_pixbuf (icon_online_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_online),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Away"));
	image = gtk_image_new_from_pixbuf (icon_away_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_away),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Not Available"));
	image = gtk_image_new_from_pixbuf (icon_na_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_na),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Free for Chat"));
	image = gtk_image_new_from_pixbuf (icon_ffc_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_ffc),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Occupied"));
	image = gtk_image_new_from_pixbuf (icon_occ_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_occ),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Do Not Disturb"));
	image = gtk_image_new_from_pixbuf (icon_dnd_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_dnd),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Invisible"));
	image = gtk_image_new_from_pixbuf (icon_inv_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_invisible),
	                  NULL);

	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	item = gtk_image_menu_item_new_with_label (_("Offline"));
	image = gtk_image_new_from_pixbuf (icon_offline_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_offline),
	                  NULL);

	gtk_widget_show_all (status_menu);

	gtk_menu_popup (GTK_MENU( status_menu), NULL, NULL,
	                NULL, NULL,
	                event->button, event->time);

	return TRUE;
}

void tray_destroyed(GtkObject *object, gpointer data)
{

  tray_icon = NULL;

  g_idle_add((GSourceFunc)tray_init, NULL);

}
