/***************************************************************************
                            StubProcess.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef STUBPROCESS_H
#define STUBPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/PtyProcess.h>

/**

 Chat with kdesu_stub.

 StubProcess extends PtyProcess with functionality to chat with kdesu_stub.
 
 @short 
 Chat with kdesu_stub.
*/
@interface StubProcess : PtyProcess 
- init;
- (void) dealloc;

/**  Specify dcop transport *
*/
- setDcopTransport: (NSString *)dcopTransport;

/**  Set the command. 
*/
- setCommand: (NSString *)command;

/**  Set the target user.  
*/
- setUser: (NSString *)user;

/** 
 Set to "X only mode": Sycoca is not built and kdeinit is not launched.
     
*/
- setXOnly: (BOOL)xonly;

/** 
 Enable DCOP forwarding.
     
*/
- setDCOPForwarding: (BOOL)dcopForwarding;

/** 
 Set the priority of the process. The priority value must be between 0
 and 100, 0 being the lowest priority. This value is mapped to the
 scheduler and system dependant priority range of the OS.
     
*/
- setPriority: (int)prio;

/** 
 Set the scheduler type. 
     
*/
- setScheduler: (int)sched;

/**  Exchange all parameters with kdesu_stub. 
*/
- (int) ConverseStub: (int)check;

/**  Notify the taskbar that a new application has been started. 
*/
- notifyTaskbar: (NSString *)suffix;

/**  
 This virtual function can be overloaded when special behaviour is
 desired. By default, it returns the value returned by @ref  #-KCookie.
     
*/
- (NSString *) display;

/**  See @ref  #-display. 
*/
- (NSString *) displayAuth;

/**  See @ref  #-display. 
*/
- (NSString *) dcopServer;

/**  See @ref  #-display. 
*/
- (NSString *) dcopAuth;

/**  See @ref  #-display. 
*/
- (NSString *) iceAuth;
+ (int) SchedNormal;
+ (int) SchedRealtime;
@end

#endif
