/***************************************************************************
                            KScanDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCANDIALOG_H
#define KSCANDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 This is a base class for scanning dialogs. You can derive from this class
 and implement your own dialog. An implementation is available in
 kdegraphics/libkscan.

 Application developers that wish to add scanning support to their program
 can use the static method @p -[KScanDialog getScanDialog] to get an instance
 of the user's preferred scanning dialog.

 Typical usage looks like this (e.g. in a -slotShowScanDialog method):

 <pre>
 if ( !m_scanDialog ) {
     m_scanDialog = -[KScanDialog getScanDialog]( this, "scandialog" );
     if ( !m_scanDialog ) // no scanning support installed?
         return;

     connect( m_scanDialog, SIGNAL( finalImage( const QImage&, int )),
              SLOT( slotScanned( const QImage&, int ) ));
 }

 if ( -[m_scanDialog setup] ) // only if scanner configured/available
     -[m_scanDialog show];
 </pre>

 This will create and show a non-modal scanning dialog. Connect to more
 signals if you like.

 If you implement an own scan-dialog, you also have to implement a
 KScanDialogFactory.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A baseclass and accessor for Scanning Dialogs.
*/
@class parse; 

@interface KScanDialog : KDialogBase 

/** 
 Destructs the scan dialog.
     
*/
- (void) dealloc;

/** 
 Reimplement this if you need to set up some things, before showing the
 dialog, e.g. to ask the user for the scanner device to use. If you 
 return false (e.g. there is no device available or the user aborted
 device selection), the dialog will not be shown.

 Returns true by default.
     
*/
- (BOOL) setup;

/** 
 Creates the user's preferred scanning dialog and returns it,
 or 0L if no scan-support
 is available. Pass a suitable @p parent widget, if you like. If you
 don't you have to 'delete' the returned pointer yourself.
     
*/
+ (KScanDialog*) getScanDialog: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
+ (KScanDialog*) getScanDialog;

/** 
 Constructs the scan dialog. If you implement an own dialog, you can
 customize it with the usual @ref KDialogBase flags.

*/
- initWithInt: (int)dialogFace buttonMask: (int)buttonMask parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- init;

/** 

*/
- (int) id;

/** 

     
*/
- (int) nextId;
@end

/** Override these methods in subclasses of KScanDialog to customise event handling behaviour */
@protocol KScanDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
