/***************************************************************************
                            KJavaApplet.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KJAVAAPPLET_H
#define KJAVAAPPLET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

@interface KJavaApplet : QObject 
//- initWithJavaAppletWidget: (KJavaAppletWidget*)_parent _context: (KJavaAppletContext*)_context;
//- initWithJavaAppletWidget: (KJavaAppletWidget*)_parent ;
- (void) dealloc;

/** 
 Specify the name of the class file to run. For example 'Lake.class'.
     
*/
- setAppletClass: (NSString *)clazzName;

/** 
 Get the name of the Class file the applet should run
     
*/
- (NSString *) appletClass;

/** 
 Set the URL of the document embedding the applet.
     
*/
- setBaseURL: (NSString *)base;

/** 
 get the Base URL of the document embedding the applet
     
*/
- (NSString *) baseURL;

/** 
 Set the codebase of the applet classes.
     
*/
- setCodeBase: (NSString *)codeBase;

/** 
 Get the codebase of the applet classes
     
*/
- (NSString *) codeBase;

/** 
 Set the list of archives at the Applet's codebase to search in for
 class files and other resources
     
*/
- setArchives: (NSString *)_archives;

/** 
 Get the list of Archives that should be searched for class files
 and other resources
     
*/
- (NSString *) archives;

/** 
 Set the name the applet should be called in it's context
     
*/
- setAppletName: (NSString *)name;

/** 
 Get the name the applet should be called in it's context
     
*/
- (NSString *) appletName;

/** 
 Set the size of the applet
     
*/
- setSize: (QSize *)size;

/** 
 Get the size of the applet
     
*/
- (QSize*) size;

/** 
 Specify a parameter to be passed to the applet.
     
*/
- setParameter: (NSString *)name value: (NSString *)value;

/** 
 Look up the parameter value for the given Parameter.  Returns
 -[QString null]if the name has not been set.
     
*/
- (NSString *) parameter: (NSString *)name;

/** 
 Set the window title for swallowing
     
*/
- setWindowName: (NSString *)title;

/** 
 Get the window title this applet should use
     
*/
- (NSString *) getWindowName;

/** 
 Interface for applets to resize themselves
     
*/
- resizeAppletWidget: (int)width height: (int)height;

/** 
 Send message to AppletServer to create this applet's
 frame to be swallowed and download the applet classes
     
*/
- create;

/** 
 Send message to AppletServer to Initialize and show
 this applet
     
*/
- init;

/** 
 Returns status of applet- whether it's been created or not
     
*/
- (BOOL) isCreated;

/** 
 Run the applet.
     
*/
- start;

/** 
 Pause the applet.
     
*/
- stop;

/** 
 Returns the unique ID this applet is given
     
*/
- (int) appletId;

/** 
 Set the applet ID.
     
*/
- setAppletId: (int)identifier;
@end

/** Override these methods in subclasses of KJavaApplet to customise event handling behaviour */
@protocol KJavaAppletEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
