/***************************************************************************
                            KDockManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDOCKMANAGER_H
#define KDOCKMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
 More or less a helper class for the KDockWidget class set but of interest for some functionality
 that can be called within a @ref KDockMainWindow or a @ref KDockWidget .

 An important feature is the ability to read or save the current state of all things concerning to
 dockwidgets to @ref KConfig .

 The dockmanager is also often used when a certain dockwidget or a child of such dockwidget must be found.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
*/
@class KConfig; 
@class KDockWidget; 
@class QDomElement; 
@class QPopupMenu; 
@class parse; 

@interface KDockManager : QObject 

/** 
 Constructs a dockmanager. Some initialization happen:

*/
- initWithWidget: (QWidget *)mainWindow name: (NSString *)name;
- initWithWidget: (QWidget *)mainWindow ;

/** 
 Destructs a dockmanager.
   
*/
- (void) dealloc;

/** 
 Saves the current state of the dockmanager and of all controlled widgets.
 State means here to save the geometry, visibility, parents, internal object names, orientation,
 separator positions, dockwidget-group information, tab widget states (if it is a tab group) and
 last but not least some necessary things for recovering the dockmainwindow state.

*/
- writeConfig: (KConfig*)c group: (NSString *)group;
- writeConfig;

/** 
 Like writeConfig but reads the whole stuff in.

 In order to restore a window configuration
 from a config file, it looks up widgets by name
 (-[QObject name]) in the childDock variable of
 KDockManager. This list in turn contains all
 KDockWidgets (according to the KDockWidget constructor).
 So in principle, in order to restore a window layout,
 one must first construct all widgets, put each of them in a
 KDockWidget and then call -readConfig. And for all that
 to work, each widget must have a unique name.

*/
- readConfig: (KConfig*)c group: (NSString *)group;
- readConfig;

/** 
 Saves the current dock window layout into a DOM tree below the given element.
   
*/
- writeConfig: (QDomElement*)base;

/** 
 Reads the current dock window layout from a DOM tree below the given element.
   
*/
- readConfig: (QDomElement*)base;

/** 
 Shows all encapsulated widgets of all controlled dockwidgets and shows all dockwidgets which are
 parent of a dockwidget tab group.
   
*/
- activate;

/** 
 It's more or less a method that catches several events which are interesting for the dockmanager.
 Mainly mouse events during the drag process of a dockwidgets are of interest here.

*/
- (BOOL) eventFilter: (QObject *)arg1 event: (QEvent *)arg2;

/** 
 This method finds out what a widgets' dockwidget is. That means the dockmanager has a look at all
 dockwidgets it knows and tells you when one of those dockwidgets covers the given widget.

*/
- (KDockWidget*) findWidgetParentDock: (QWidget *)w;

/** 
 Works like -makeDockVisible but can be called for widgets that covered by a dockwidget.

*/
- makeWidgetDockVisible: (QWidget *)w;

/** 

*/
- (QPopupMenu*) dockHideShowMenu;

/** 

*/
- (KDockWidget*) getDockWidgetFromName: (NSString *)dockName;

/** 
 Enables opaque resizing. Opaque resizing is initially turned off.
 Call this method before you create any dock widgets!   
   
*/
- setSplitterOpaqueResize: (BOOL)b;
- setSplitterOpaqueResize;

/** 
 Returns TRUE if opaque resizing is enabled, FALSE otherwise.
   
*/
- (BOOL) splitterOpaqueResize;

/** 
 Try to preserve the widget's size. Works like KeepSize resize mode
 of QSplitter. Off by default.
 Call this method before you create any dock widgets!
   
*/
- setSplitterKeepSize: (BOOL)b;
- setSplitterKeepSize;

/** 
 Returns TRUE if the KeepSize is enabled, FALSE otherwise.
   
*/
- (BOOL) splitterKeepSize;

/** 
 Operate the splitter with a higher resolution. Off by default.
 Call this method before you create any dock widgets!
 If high resolution is used all splitter position parameters
 are percent*100 instead of percent.
   
*/
- setSplitterHighResolution: (BOOL)b;
- setSplitterHighResolution;

/** 
 Returns TRUE if the splitter uses the high resolution, FALSE otherwise.
   
*/
- (BOOL) splitterHighResolution;
@end

/** Override these methods in subclasses of KDockManager to customise event handling behaviour */
@protocol KDockManagerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
