/***************************************************************************
                            KArchive.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KARCHIVE_H
#define KARCHIVE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**


 @author David Faure <faure@kde.org>
 
 @short generic class for reading/writing archives.
*/

@class QIODevice;
@class KArchiveDirectory;

@interface  KArchive : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Opens the archive for reading or writing.

*/
- (BOOL) open: (int)mode;

/** 
 Closes the archive.
 Inherited classes might want to reimplement openArchive instead.

*/
- close;

/** 

*/
- (BOOL) isOpened;

/** 

*/
- (int) mode;

/** 
 The underlying device.
     
*/
- (QIODevice*) device;

/** 
 If an archive is opened for reading, then the contents
 of the archive can be accessed via this function.
     
*/
- (KArchiveDirectory*) directory;

/** 
 If an archive is opened for writing then you can add new directories
 using this function. KArchive won't write one directory twice.
     
*/
- (BOOL) writeDir: (NSString *)name user: (NSString *)user group: (NSString *)group;

/** 
 If an archive is opened for writing then you can add a new file
 using this function. If the file name is for example "mydir/test1" then
 the directory "mydir" is automatically appended first if that did not
 happen yet.
     
*/
- (BOOL) writeFile: (NSString *)name user: (NSString *)user group: (NSString *)group size: (unsigned int)size data: (NSString *)data;

/** 
 Here's another way of writing a file into an archive:
 Call @ref prepareWriting, then call write as many times as wanted,
 then call @ref doneWriting( totalSize )
 You need to know the size before hand, it is needed in the header!
     
*/
- (BOOL) prepareWriting: (NSString *)name user: (NSString *)user group: (NSString *)group size: (unsigned int)size;

/** 
 Call @ref doneWriting after writing the data.

*/
- (BOOL) doneWriting: (unsigned int)size;
@end

#endif
