/***************************************************************************
                            Job.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef JOB_H
#define JOB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The base class for all jobs.
 For all jobs created in an application, the code looks like

 <pre>
   -[KIO Job]* job = -[KIO someoperation]( some parameters );
   connect( job, SIGNAL( result( -[KIO Job]* ) ),
            this, SLOT( slotResult( -[KIO Job]* ) ) );
 </pre>
   (other connects, specific to the job)

 And slotResult is usually at least:

 <pre>
  if ( -[job error] )
      -[job showErrorDialog]( this or 0L  );
 </pre>

     
 @short 
 The base class for all jobs.
*/

@interface Job : QObject 
- (void) dealloc;

/** 
 Abort this job.
 This kills all subjobs and deletes the job.

*/
- kill: (BOOL)quietly;
- kill;

/** 

*/
- (int) error;

/** 

*/
- (int) progressId;

/** 

*/
- (NSString *) errorText;

/** 
 Converts an error code and a non-i18n error message into an
 error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.
 Example for errid == ERR_CANNOT_OPEN_FOR_READING:
   i18n( "Could not read\n%1" ).arg( errortext );
 Use this to display the error yourself, but for a dialog box
 use @ref -[Job showErrorDialog].
         
*/
- (NSString *) errorString;

/** 
 Converts an error code and a non-i18n error message into an
 html error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.
         
*/
- (NSString *) htmlErrorString;

/** 
 Display a dialog box to inform the user of the error given by
 this job.
 Only call if @ref error is not 0, and only in the slot connected
 to @ref result.

*/
- showErrorDialog: (QWidget *)parent;
- showErrorDialog;

/** 
 Enable or disable the automatic error handling. When automatic
 error handling is enabled and an error occurs, then showErrorDialog
 is called with the specified parentWidget (if supplied) , right before
 the emission of the result signal.

 The default is false.

 See also @ref isAutoErrorHandlingEnabled , @ref showErrorDialog

*/
- setAutoErrorHandlingEnabled: (BOOL)enable parentWidget: (QWidget *)parentWidget;
- setAutoErrorHandlingEnabled: (BOOL)enable ;

/** 
 Returns whether automatic error handling is enabled or disabled.
 See also @ref setAutoErrorHandlingEnabled .
         
*/
- (BOOL) isAutoErrorHandlingEnabled;

/** 
 Associate this job with a window given by @p window.
         
*/
- setWindow: (QWidget *)window;

/** 
 Returns the window this job is associated with.
         
*/
- (QWidget*) window;

/** 
 Set meta data to be sent to the slave.
         
*/
//- setMetaData: (MetaData*)arg1;

/** 
 Add key/value pair to the meta data that is sent to the slave.
         
*/
- addMetaData: (NSString *)key value: (NSString *)value;

/** 

         
*/
//- (MetaData*) outgoingMetaData;

/** 
 Get meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
//- (MetaData*) metaData;

/** 
 Query meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
- (NSString *) queryMetaData: (NSString *)key;
- initWithBOOL: (BOOL)showProgressInfo;

/** 
 Add a job that has to be finished before a result
 is emitted. This has obviously to be called before
 the finish signal is emitted by the slave.

 If @p inheritMetaData is true, the subjob will 
 inherit the meta data from this job.
         
*/
- addSubjob: (void*)job inheritMetaData: (BOOL)inheritMetaData;
- addSubjob: (void*)job ;

/** 
 Mark a sub job as being done. If it's the last to
 wait on the job will emit a result - jobs with
 two steps might want to override slotResult
 in order to avoid calling this method.
         
*/
- removeSubjob: (void*)job;

/** 
 Utility function for inherited jobs.
 Emits the percent signal if bigger than m_percent,
 after calculating it from the parameters.
         
*/
- emitPercent: (unsigned long)processedSize totalSize: (unsigned long)totalSize;

/** 
 Utility function for inherited jobs.
 Emits the speed signal and starts the timer for removing that info
         
*/
- emitSpeed: (unsigned long)bytes_per_second;

/** 
 Utility function to emit the result signal, and suicide this job.
 It first tells the observer to hide the progress dialog for this job.
         
*/
- emitResult;

/** 
 Called whenever a subjob finishes.
 Default implementation checks for errors and propagates
 to parent job, then calls @ref removeSubjob.
 Override if you don't want subjobs errors to be propagated.
         
*/
- slotResult: (Job*)job;

/** 
 Forward signal from subjob.
         
*/
- slotSpeed: (Job*)arg1 bytes_per_second: (unsigned long)bytes_per_second;

/** 
 Forward signal from subjob.
         
*/
- slotInfoMessage: (Job*)arg1 string: (NSString *)arg2;

/** 
 Remove speed information.
         
*/
- slotSpeedTimeout;
@end

/** Override these methods in subclasses of Job to customise event handling behaviour */
@protocol JobEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
