/***************************************************************************
                            KUniqueApplication.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Maintains only a single
 instance of a running application at a time.

 If another instance
 is started, it will determine (via DCOP) whether it is the first instance
 or a second instance.  If it is a second instance, it will forward on
 the information to the first instance and then quit.

 See {@link KUniqueApplicationSignals} for signals emitted by KUniqueApplication.

 

 @author Preston Brown <pbrown@kde.org>
 
 @short *
 Maintains only a single
 instance of a running application at a time.
*/
public class KUniqueApplication extends KApplication implements  DCOPObjectInterface {
	protected KUniqueApplication(Class dummy){super((Class) null);}

	private native void newKUniqueApplication( boolean allowStyles, boolean GUIenabled, boolean configUnique);

/** 
 Constructor. Takes command line arguments from KCmdLineArgs

*/
	public KUniqueApplication( boolean allowStyles, boolean GUIenabled, boolean configUnique) {
		super((Class) null);
		newKUniqueApplication( allowStyles, GUIenabled, configUnique);
	}
	private native void newKUniqueApplication();
	public KUniqueApplication() {
		super((Class) null);
		newKUniqueApplication();
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Dispatches any incoming DCOP message for a new instance.

 If it is not a request for a new instance, return false.
 Overloaded from {@link DCOPObject} to make sure that the application
 stays unique.

*/
	public native boolean process( String fun, byte[] data, String replyType, byte[] replyData);

/** 
 Creates a new "instance" of the application.

 Usually this will involve making some calls into the GUI portion of your
 application asking for a new window to be created, possibly with
 some data already loaded based on the arguments received.

 Command line arguments have been passed to KCmdLineArgs before this
 function is called and can be checked in the usual way.

 Note that newInstance() is called also in the first started 
 application process.

*/
	public native int newInstance();

/** 
 Adds command line options specific for KUniqueApplication.

 Should be called before calling KUniqueApplication constructor
 and / or start().
   
*/
	public static native void addCmdLineOptions();

/** 
 Forks and registers with dcop.

 The command line arguments are being sent via DCOP to {@link #newInstance}
 and will be received once the application enters the event loop.

 Typically this is used like:
 <pre>
 int main(String[] args) {
    KAboutData about("myappname", "myAppName", .....);
    KCmdLineArgs.init(args, &about);
    KCmdLineArgs.addCmdLineOptions( myCmdOptions );
    KUniqueApplication.addCmdLineOptions();

    if (!KUniqueApplication.start()) {
       fprintf(stderr, "myAppName is already running!\n");
       exit(0);
    }
    KUniqueApplication a;
    a.exec();
 }
 </pre>
 Note that it's not necessary to call {@link #start} explicitly. It will be
 called automatically before creating KUniqueApplication if it hasn't
 been called yet, without any performance impact.

*/
	public static native boolean start();
	protected native void virtual_hook( int identifier, int data);


 	// From DCOPObjectInterface

 /**
 Returns the object id of the DCOPObject.

*/
	public native String objId();

/**
 Renames a dcop object, if no other with the same name exists
 Use with care, all dcop signals are disconnected

*/
	public native boolean setObjId( String objId);


/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #process} but
 you still want to dispatch some functions dynamically.
 Dynamically means that methods may appear and vanish
 during runtime.

*/
	public native boolean processDynamic( String fun, byte[] data, String replyType, byte[] replyData);

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #functions} but
 you still want to list some functions dynamically.
 Dynamically means that the methods may appear and vanish
 during runtime.

*/
	public native ArrayList functionsDynamic();

/**
 This function is of interest when you used an IDL compiler
 to generate the implementation for {@link #interfaces} but
 you still want to list some interfaces dynamically.
 Dynamically means that they may appear and vanish
 during runtime.

*/
	public native ArrayList interfacesDynamic();

/**
 Returns the names of the interfaces, specific ones last. The
 functions gets reimplemented by the IDL compiler. If you don't
 use the IDL compiler, consider implementing this function
 manually if you want your object to be easily explorable.

*/
	public native ArrayList interfaces();

/**
 Returns the list of functions understood by the object. It gets
 reimplemented by the IDL compiler. If you don't use the IDL
 compiler, consider implementing this function manually if you
 want your object to be easily scriptable.

 Rationale: functions() allows an interpreter to do client-side
 type-casting properly.

 Note to implementators: remember to call the baseclasses
 implementation.

*/
	public native ArrayList functions();

/**
 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
 arguments

*/
	public native void emitDCOPSignal( String signal, byte[] data);

/**
 Connects to a DCOP signal.

*/
	public native boolean connectDCOPSignal( String sender, String senderObj, String signal, String slot, boolean Volatile);

/**
 Disconnects a DCOP signal.

 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
 case all connections related to this object in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
	public native boolean disconnectDCOPSignal( String sender, String senderObj, String signal, String slot);

/**
 Returns the {@link DCOPClient} responsible for making the call.
 Only call this function while you are handling a DCOP call.

*/
	public native DCOPClient callingDcopClient();

/**

*/
	public native void setCallingDcopClient( DCOPClient arg1);
}
