/***************************************************************************
                            KRegExp.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Regular expression (regexp) matching with back-references.

 This was implemented
 because {@link QRegExp} does not support back-references.

 Back-references are parts of a regexp grouped with parentheses. If a
 string matches the regexp, you can access the text that matched each
 group with the {@link group} method. This is similar to regular expressions 
 in Perl.

 Example:
 <pre>
  KRegExp ex( "([A-Za-z]+) (.+)" );
  ex.match( "42 Torben Weis" );
  kdDebug() << ex.group(0) << endl;
  kdDebug() << ex.group(1) << endl;
  kdDebug() << ex.group(2) << endl;
 </pre>
 Output:
 <pre>
  Torben Weis
  Torben
  Weis
 </pre>

 Please notice that KRegExp does <em>not</em> support unicode.

 @author Torben Weis <weis@kde.org>

 @version $Id: KRegExp.java,v 1.7 2002/11/26 04:17:34 rdale Exp $
 
 @short *
 Regular expression (regexp) matching with back-references.
*/
public class  KRegExp implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KRegExp(Class dummy){}

	private native void newKRegExp();

/** 
 Creates a KRegExp object without a default pattern.
   
*/
	public KRegExp() {
		newKRegExp();
	}
	private native void newKRegExp( String _pattern, String _mode);

/** 
 Creates a KRegExp object.

*/
	public KRegExp( String _pattern, String _mode) {
		newKRegExp( _pattern, _mode);
	}
	private native void newKRegExp( String _pattern);
	public KRegExp( String _pattern) {
		newKRegExp( _pattern);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Prepare a regular expression for subsequent matches.

*/
	public native boolean compile( String _pattern, String _mode);
	public native boolean compile( String _pattern);

/** 
 Match a string to the last supplied regexp.

*/
	public native boolean match( String _string);

/** 
 Returns a group from the match.

*/
	public native String group( int _grp);

/** 
 The offset of the given group in the string.

*/
	public native int groupStart( int _grp);

/** 
 The offset of the given group's end in the string.

*/
	public native int groupEnd( int _grp);
}
