/***************************************************************************
                            KMessageBox.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Easy message dialog box.

 Provides convenience functions for some i18n'ed standard dialogs.

 The text in message boxes is wrapped automatically. The text may either
 be plaintext or richtext. If the text is plaintext, a newline-character
 may be used to indicate the end of a paragraph.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: KMessageBox.java,v 1.11 2002/11/26 04:17:33 rdale Exp $
  
 @short *
 Easy message dialog box.
*/
public class  KMessageBox implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KMessageBox(Class dummy){}


/** 
 Display a simple "question" dialog.

 To be used for questions like "Do you have a printer?"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
	public static native int questionYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static int questionYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo) {
		return questionYesNo(parent, text, caption, buttonYes, buttonNo, null, Notify);
	}
	public static int questionYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes) {
		return questionYesNo(parent, text, caption, buttonYes, KStdGuiItem.no(), null, Notify);
	}
	public static int questionYesNo( QWidget parent, String text, String caption) {
		return questionYesNo(parent, text, caption, KStdGuiItem.yes(), KStdGuiItem.no(), null, Notify);
	}
	public static native int questionYesNo( QWidget parent, String text);

/** 
 Display a simple "question" dialog.

 To be used for questions like "Do you want to discard the message or save it for later?",

 The default button is "Yes". Pressing "Esc" selects "Cancel".

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
	public static native int questionYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static int questionYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo) {
		return questionYesNoCancel(parent, text, caption, buttonYes, buttonNo, null, Notify);
	}
	public static int questionYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes) {
		return questionYesNoCancel(parent, text, caption, buttonYes, KStdGuiItem.no(), null, Notify);
	}
	public static int questionYesNoCancel( QWidget parent, String text, String caption) {
		return questionYesNoCancel(parent, text, caption, KStdGuiItem.yes(), KStdGuiItem.no(), null, Notify);
	}
	public static native int questionYesNoCancel( QWidget parent, String text);

/** 
 Display a "question" dialog with a listbox to show information to the user

 To be used for questions like "Do you really want to delete these files?"
 And show the user exactly which files are going to be deleted in case
 he presses "Yes"

 The default button is "Yes". Pressing "Esc" selects "No".
  
*/
	public static native int questionYesNoList( QWidget parent, String text, String[] strlist, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static native int questionYesNoList( QWidget parent, String text, String[] strlist);

/** 
 Display a "warning" dialog.

 To be used for questions "Shall I update your configuration?"
 The text should explain the implication of both options.

 The default button is "No". Pressing "Esc" selects "No".
  
*/
	public static native int warningYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static int warningYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo) {
		return warningYesNo(parent, text, caption, buttonYes, buttonNo, null, Notify);
	}
	public static int warningYesNo( QWidget parent, String text, String caption, KGuiItem buttonYes) {
		return warningYesNo(parent, text, caption, buttonYes, KStdGuiItem.no(), null, Notify);
	}
	public static int warningYesNo( QWidget parent, String text, String caption) {
		return warningYesNo(parent, text, caption, KStdGuiItem.yes(), KStdGuiItem.no(), null, Notify);
	}
	public static native int warningYesNo( QWidget parent, String text);

/** 
 Display a "warning" dialog.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
	public static native int warningContinueCancel( QWidget parent, String text, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancel( QWidget parent, String text);

/** 
 Display a "warning" dialog with a listbox to show information to the user.

 The second button always has the text "Cancel".

 To be used for questions like "You are about to Print. Are you sure?"
 the continueButton should then be labeled "Print".

 The default button is buttonContinue. Pressing "Esc" selects "Cancel".
  
*/
	public static native int warningContinueCancelList( QWidget parent, String text, String[] strlist, String caption, KGuiItem buttonContinue, String dontAskAgainName, int options);
	public static native int warningContinueCancelList( QWidget parent, String text, String[] strlist);

/** 
 Display a Yes/No/Cancel "warning" dialog.

 To be used for questions "Do you want to save your changes?"
 The text should explain the implication of choosing 'No'.

 The default button is "Yes". Pressing "Esc" selects "Cancel"

 NOTE: The cancel button will always have the i18n'ed text '&Cancel'.
  
*/
	public static native int warningYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, String dontAskAgainName, int options);
	public static int warningYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo) {
		return warningYesNoCancel(parent, text, caption, buttonYes, buttonNo, null, Notify);
	}
	public static int warningYesNoCancel( QWidget parent, String text, String caption, KGuiItem buttonYes) {
		return warningYesNoCancel(parent, text, caption, buttonYes, KStdGuiItem.no(), null, Notify);
	}
	public static int warningYesNoCancel( QWidget parent, String text, String caption) {
		return warningYesNoCancel(parent, text, caption, KStdGuiItem.yes(), KStdGuiItem.no(), null, Notify);
	}
	public static native int warningYesNoCancel( QWidget parent, String text);

/** 
 Display an "Error" dialog.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed.

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
	public static native void error( QWidget parent, String text, String caption, int options);
	public static void error( QWidget parent, String text, String caption) {
		error(parent, text, caption, Notify);
	}
	public static native void error( QWidget parent, String text);

/** 
 Displays an "Error" dialog with a "Details >>" button.

 Your program messed up and now it's time to inform the user.
 To be used for important things like "Sorry, I deleted your hard disk."

 The <code>details</code> message can conatin additional information about
 the problem and can be shown on request to advanced/interested users.

 If your program detects the action specified by the user is somehow
 not allowed, this should never be reported with error(). Use sorry()
 instead to explain to the user that this action is not allowed.

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The OK button will always have the i18n'ed text '&OK'.
  
*/
	public static native void detailedError( QWidget parent, String text, String details, String caption, int options);
	public static void detailedError( QWidget parent, String text, String details, String caption) {
		detailedError(parent, text, details, caption, Notify);
	}
	public static native void detailedError( QWidget parent, String text, String details);

/** 
 Like {@link detailedError}

 This function will return immediately, the messagebox will be shown
 once the application enters an event loop and no other messagebox
 is being shown.

 Note that if the parent gets deleted, the messagebox will not be
 shown.
   
*/
	public static native void queuedDetailedError( QWidget parent, String text, String details, String caption);
	public static native void queuedDetailedError( QWidget parent, String text, String details);

/** 
 Display an "Sorry" dialog.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like
 "Sorry, I can't find the file you specified."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
	public static native void sorry( QWidget parent, String text, String caption, int options);
	public static void sorry( QWidget parent, String text, String caption) {
		sorry(parent, text, caption, Notify);
	}
	public static native void sorry( QWidget parent, String text);

/** 
 Displays a "Sorry" dialog with a "Details >>" button.

 Either your program messed up and asks for understanding
 or your user did something stupid.

 To be used for small problems like
 "Sorry, I can't find the file you specified."

 And then <code>details</code> can contain something like
 "foobar.txt was not found in any of
  the following directories:
  /usr/bin,/usr/local/bin,/usr/sbin"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

 NOTE: The ok button will always have the i18n'ed text '&OK'.
  
*/
	public static native void detailedSorry( QWidget parent, String text, String details, String caption, int options);
	public static void detailedSorry( QWidget parent, String text, String details, String caption) {
		detailedSorry(parent, text, details, caption, Notify);
	}
	public static native void detailedSorry( QWidget parent, String text, String details);

/** 
 Display an "Information" dialog.

 Your program wants to tell the user something.
 To be used for things like:
 "Your bookmarks have been rearranged."

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.

*/
	public static native void information( QWidget parent, String text, String caption, String dontShowAgainName, int options);
	public static void information( QWidget parent, String text, String caption, String dontShowAgainName) {
		information(parent, text, caption, dontShowAgainName, Notify);
	}
	public static void information( QWidget parent, String text, String caption) {
		information(parent, text, caption, "", Notify);
	}
	public static native void information( QWidget parent, String text);

/** 
 Display an "Information" dialog with a listbox.

 Your program wants to tell the user something.
 To be used for things like:
 "The following bookmarks have been rearranged:"

 The default button is "&OK". Pressing "Esc" selects the OK-button.

  NOTE: The OK button will always have the i18n'ed text '&OK'.

*/
	public static native void informationList( QWidget parent, String text, String[] strlist, String caption, String dontShowAgainName, int options);
	public static native void informationList( QWidget parent, String text, String[] strlist);

/** 
 Enable all messages which have been turned off with the
 <code>dontShowAgainName</code> feature of the information dialog.
   
*/
	public static native void enableAllMessages();

/** 
 Display an "About" dialog.

 Your program wants to show some general information about the application
 like the authors's names and email addresses.

 The default button is "&OK".

  NOTE: The ok button will always have the i18n'ed text '&OK'.
   
*/
	public static native void about( QWidget parent, String text, String caption, int options);
	public static void about( QWidget parent, String text, String caption) {
		about(parent, text, caption, Notify);
	}
	public static native void about( QWidget parent, String text);

/** 
 Alternate method to show a messagebox:

*/
	public static native int messageBox( QWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo, int options);
	public static int messageBox( QWidget parent, int type, String text, String caption, KGuiItem buttonYes, KGuiItem buttonNo) {
		return messageBox(parent, type, text, caption, buttonYes, buttonNo, Notify);
	}
	public static int messageBox( QWidget parent, int type, String text, String caption, KGuiItem buttonYes) {
		return messageBox(parent, type, text, caption, buttonYes, KStdGuiItem.no(), Notify);
	}
	public static int messageBox( QWidget parent, int type, String text, String caption) {
		return messageBox(parent, type, text, caption, KStdGuiItem.yes(), KStdGuiItem.no(), Notify);
	}
	public static native int messageBox( QWidget parent, int type, String text);
	public static native void queuedMessageBox( QWidget parent, int type, String text, String caption, int options);

/** 
 @overload

 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.
     
*/
	public static native void queuedMessageBox( QWidget parent, int type, String text, String caption);
	public static native void queuedMessageBox( QWidget parent, int type, String text);
	public static final int Ok = 1;
	public static final int Cancel = 2;
	public static final int Yes = 3;
	public static final int No = 4;
	public static final int Continue = 5;
	public static final int QuestionYesNo = 1;
	public static final int WarningYesNo = 2;
	public static final int WarningContinueCancel = 3;
	public static final int WarningYesNoCancel = 4;
	public static final int Information = 5;
	public static final int Sorry = 7;
	public static final int Error = 8;
	public static final int QuestionYesNoCancel = 9;
	public static final int Notify = 1;
	public static final int AllowLink = 2;
}
