/***************************************************************************
                            KIconEffect.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Applies effects to icons.

 This class applies effects to icons depending on their state and
 group. For example, it can be used to make all disabled icons
 in a toolbar grey.

 @short *
 Applies effects to icons.
*/
public class  KIconEffect implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIconEffect(Class dummy){}

	private native void newKIconEffect();

/** 
 Create a new KIconEffect.
   
*/
	public KIconEffect() {
		newKIconEffect();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Rereads configuration.
     
*/
	public native void init();

/**  
 Tests whether an effect has been configured for the given icon group.

*/
	public native boolean hasEffect( int group, int state);

/** 
 Returns a fingerprint for the effect by encoding
 the given <code>group</code> and <code>state</code> into a String. This 
 is useful for caching.

*/
	public native String fingerprint( int group, int state);

/** 
 Applies an effect to an image. The effect to apply depends on the
 <code>group</code> and <code>state</code> parameters, and is configured by the user.

*/
	public native QImage apply( QImage src, int group, int state);

/** 
 Applies an effect to an image.

*/
	public native QImage apply( QImage src, int effect, float value, QColor rgb, boolean trans);

/** 
 Applies an effect to a pixmap.

*/
	public native QPixmap apply( QPixmap src, int group, int state);

/** 
 Applies an effect to a pixmap.

*/
	public native QPixmap apply( QPixmap src, int effect, float value, QColor rgb, boolean trans);

/** 
 Returns an image twice as large, consisting of 2x2 pixels.

*/
	public native QImage doublePixels( QImage src);

/** 
 Provides visual feedback to show activation of an icon on a widget.

 Not strictly an 'icon effect', but in practice that's what it looks
 like.

 This method does nothing if the global 'Visual feedback on activation'
 option is not activated (See kcontrol/Peripherals/Mouse).

*/
	public static native void visualActivate( QWidget widget, QRect rect);

/** 
 Tints an image gray.

*/
	public static native void toGray( QImage image, float value);

/** 
 Colorizes an image with a specific color.

*/
	public static native void colorize( QImage image, QColor col, float value);

/** 
 Desaturates an image.

*/
	public static native void deSaturate( QImage image, float value);

/** 
 Changes the gamma value of an image.

*/
	public static native void toGamma( QImage image, float value);

/** 
 Renders an image semi-transparent.

*/
	public static native void semiTransparent( QImage image);

/** 
 Renders a pixmap semi-transparent.

*/
	public static native void semiTransparent( QPixmap pixmap);

/** 
 Overlays an image with an other image.

*/
	public static native void overlay( QImage src, QImage overlay);
	public static final int NoEffect = 0;
	public static final int ToGray = 1;
	public static final int Colorize = 2;
	public static final int ToGamma = 3;
	public static final int DeSaturate = 4;
	public static final int LastEffect = 5;
}
