/***************************************************************************
                            KGradientSelector.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
 
 See {@link KGradientSelectorSignals} for signals emitted by KGradientSelector.

 

 @short *
 The KGradientSelector widget allows the user to choose
 from a one-dimensional range of colors which is given as a
 gradient between two colors provided by the programmer.
*/
public class KGradientSelector extends KSelector  {
	protected KGradientSelector(Class dummy){super((Class) null);}

	private native void newKGradientSelector( QWidget parent, String name);

/** 
 Constructs a horizontal color selector which
 contains a gradient between white and black.
   
*/
	public KGradientSelector( QWidget parent, String name) {
		super((Class) null);
		newKGradientSelector( parent, name);
	}
	private native void newKGradientSelector();
	public KGradientSelector() {
		super((Class) null);
		newKGradientSelector();
	}
	private native void newKGradientSelector( int o, QWidget parent, String name);

/** 
 Constructs a colors selector with orientation o which
 contains a gradient between white and black.
   
*/
	public KGradientSelector( int o, QWidget parent, String name) {
		super((Class) null);
		newKGradientSelector( o, parent, name);
	}
	public KGradientSelector( int o, QWidget parent) {
		this( o, parent, null);
	}
	private native void newKGradientSelector( int o);
	public KGradientSelector( int o) {
		super((Class) null);
		newKGradientSelector( o);
	}

/** 
 Destructs the widget.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the two colors which span the gradient.
   
*/
	public native void setColors( QColor col1, QColor col2);
	public native void setText( String t1, String t2);

/** 
 Set each color on its own.
   
*/
	public native void setFirstColor( QColor col);
	public native void setSecondColor( QColor col);

/** 
 Set each description on its own
   
*/
	public native void setFirstText( String t);
	public native void setSecondText( String t);
	public native QColor firstColor();
	public native QColor secondColor();
	public native String firstText();
	public native String secondText();
	protected native void virtual_hook( int identifier, int data);
}
