/***************************************************************************
                            KDatePicker.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides a widget for calendar date input.

     Different from the
     previous versions, it now emits two types of signals, either
     {@link #dateSelected} or {@link #dateEntered} (see documentation for both
     signals).

     A line edit has been added in the newer versions to allow the user
     to select a date directly by entering numbers like 19990101
     or 990101.

 \image html kdatepicker.png "KDE Date Widget"

 See {@link KDatePickerSignals} for signals emitted by KDatePicker.

 

 @author Tim Gilman, Mirko Boehm

 @version $Id: KDatePicker.java,v 1.8 2002/11/26 04:17:32 rdale Exp $

 @short A date selection widget.

*/
public class KDatePicker extends QFrame  {
	protected KDatePicker(Class dummy){super((Class) null);}

	private native void newKDatePicker( QWidget parent, Calendar arg1, String name);

/**  The usual constructor.  The given date will be displayed
 initially.

*/
	public KDatePicker( QWidget parent, Calendar arg1, String name) {
		super((Class) null);
		newKDatePicker( parent, arg1, name);
	}
	public KDatePicker( QWidget parent) {
		this( parent, Calendar.getInstance(), null);
	}
	private native void newKDatePicker();
	public KDatePicker() {
		super((Class) null);
		newKDatePicker();
	}
	private native void newKDatePicker( QWidget parent, Calendar arg1, String name, int f);

/**  The usual constructor.  The given date will be displayed
 initially.

*/
	public KDatePicker( QWidget parent, Calendar arg1, String name, int f) {
		super((Class) null);
		newKDatePicker( parent, arg1, name, f);
	}
	private native void newKDatePicker( QWidget parent, String name);

/** 
 Standard qt widget constructor. The initial date will be the
 current date.

*/
	public KDatePicker( QWidget parent, String name) {
		super((Class) null);
		newKDatePicker( parent, name);
	}

/** 
 The destructor.

*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/**  The size hint for date pickers. The size hint recommends the
   minimum size of the widget so that all elements may be placed
  without clipping. This sometimes looks ugly, so when using the
  size hint, try adding 28 to each of the reported numbers of
  pixels.

*/
	public native QSize sizeHint();

/** 
 Sets the date.

*/
	public native boolean setDate( Calendar arg1);

/** 
 Returns the selected date.

*/
	public native Calendar getDate();

/** 

*/
	public native Calendar date();

/** 
 Enables or disables the widget.

*/
	public native void setEnabled( boolean arg1);

/** 
 Sets the font size of the widgets elements.

*/
	public native void setFontSize( int arg1);

/** 
 Returns the font size of the widget elements.
   
*/
	public native int fontSize();

/** 
 By calling this method with <code>enable</code> = true, KDatePicker will show
 a little close-button in the upper button-row. Clicking the
 close-button will cause the KDatePicker's topLevelWidget()'s close()
 method being called. This is mostly useful for toplevel datepickers
 without a window manager decoration.

*/
	public native void setCloseButton( boolean enable);

/** 

*/
	public native boolean hasCloseButton();
	public native boolean eventFilter( QObject o, QEvent e);
	protected native void resizeEvent( QResizeEvent arg1);
	protected native void virtual_hook( int identifier, int data);
	protected native void dateChangedSlot( Calendar arg1);
	protected native void tableClickedSlot();
	protected native void monthForwardClicked();
	protected native void monthBackwardClicked();
	protected native void yearForwardClicked();
	protected native void yearBackwardClicked();
	protected native void selectWeekClicked();
	protected native void selectMonthClicked();
	protected native void selectYearClicked();
	protected native void lineEnterPressed();
}
