/***************************************************************************
                            KButtonBox.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Container widget for buttons. 

 This class uses Qt layout control to place the buttons; can handle
 both vertical and horizontal button placement.  The default border
 is now <code>0</code> (making it easier to deal with layouts). The space
 between buttons is now more Motif compliant.

 See {@link KButtonBoxSignals} for signals emitted by KButtonBox.

 

 @author Mario Weilguni <mweilguni@sime.com>

 @version $Id: KButtonBox.java,v 1.7 2002/11/26 04:17:31 rdale Exp $

 @short *
 Container widget for buttons.
*/
public class KButtonBox extends QWidget  {
	protected KButtonBox(Class dummy){super((Class) null);}

	private native void newKButtonBox( QWidget parent, int _orientation, int border, int _autoborder);

/** 
 Create an empty container for buttons.

 If <code>_orientation</code> is <code>Vertical</code>, the buttons inserted with 
 {@link #addButton} are laid out from top to bottom, otherwise they 
 are laid out from left to right.
    
*/
	public KButtonBox( QWidget parent, int _orientation, int border, int _autoborder) {
		super((Class) null);
		newKButtonBox( parent, _orientation, border, _autoborder);
	}
	private native void newKButtonBox( QWidget parent);
	public KButtonBox( QWidget parent) {
		super((Class) null);
		newKButtonBox( parent);
	}

/** 
 Free private data field
    
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

 This size is
 calculated by the width/height of all buttons plus border/autoborder.
    
*/
	public native QSize sizeHint();

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, boolean noexpand);
	public native QPushButton addButton( String text);

/** 
 Add a new {@link QPushButton}.  

*/
	public native QPushButton addButton( String text, QObject receiver, String slot, boolean noexpand);
	public native QPushButton addButton( String text, QObject receiver, String slot);

/** 
 Add a stretch to the buttonbox. 

 Can be used to separate buttons.  That is, if you add the
 buttons OK and Cancel, add a stretch, and then add the button Help,
 the buttons OK and Cancel will be left-aligned (or top-aligned
 for vertical) whereas Help will be right-aligned (or
 bottom-aligned for vertical).

*/
	public native void addStretch( int scale);
	public native void addStretch();

/** 
 This function must be called <em>once</em> after all buttons have been
 inserted.

 It will start layout control.
    
*/
	public native QLayout layout();

/** 

*/
	protected native QSize bestButtonSize();
	protected native void placeButtons();
	protected native QSize buttonSizeHint( QPushButton arg1);
	protected native void virtual_hook( int identifier, int data);
}
