/***************************************************************************
                            kde_KPixmapSplitter.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPIXMAPSPLITTER
#define KDE_KPIXMAPSPLITTER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 If you have a pixmap containing several items (icons), you can use this
 class to get the coordinates of each item.

 For example, if you have a pixmap with 25 items and you want to get the
 4th item as a pixmap (every item being 20x10 pixels):
 <pre>
 KPixmapSplitter splitter;
 splitter.setPixmap( somePixmap );
 splitter.setItemSize( QSize( 20, 10 ));

 QPixmap item( 20, 10 );
 item.fill( Qt::white );
 QRect rect = splitter.coordinates( 4 );
 if ( !rect.isEmpty() )
     bitBlt( &item, QPoint(0,0), &somePixmap, rect, CopyROP );
 </pre>

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A class to split a pixmap into several items.

*/

/** *
 Constructor, does nothing but initializing some default-values.
     
*/
kde_KPixmapSplitter * kde_new_KPixmapSplitter();
void kde_del_KPixmapSplitter( kde_KPixmapSplitter* p );

/** *
 Sets the pixmap to be splitted.
     
*/
void kde_KPixmapSplitter_setPixmap(kde_KPixmapSplitter* instPointer,qt_QPixmap * pixmap);

/** *

*/
qt_QPixmap * kde_KPixmapSplitter_pixmap(kde_KPixmapSplitter* instPointer);

/** *
 Sets the size of the items you want to get out of the given pixmap.
 The QRect of #coordinates(int) will have the width and height of exactly
 this @p size.
     
*/
void kde_KPixmapSplitter_setItemSize(kde_KPixmapSplitter* instPointer,qt_QSize * size);

/** *

*/
qt_QSize * kde_KPixmapSplitter_itemSize(kde_KPixmapSplitter* instPointer);

/** *
 If there is space between rows in the given pixmap, you have to specify
 how many pixels there are.
     
*/
void kde_KPixmapSplitter_setVSpacing(kde_KPixmapSplitter* instPointer,int spacing);

/** *
 If there is space between columns in the given pixmap, you have to
 specify how many pixels there are.
     
*/
void kde_KPixmapSplitter_setHSpacing(kde_KPixmapSplitter* instPointer,int spacing);

/** *

*/
qt_QRect* kde_KPixmapSplitter_coordinates(kde_KPixmapSplitter* instPointer,int pos);

/** *
 Overloaded for convenience. Returns the item at the position of the
 given character (when using a latin1 font-pixmap)
     
*/
qt_QRect* kde_KPixmapSplitter_coordinates1(kde_KPixmapSplitter* instPointer,qt_QChar* ch);

#endif
