/***************************************************************************
                            kde_KListView.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLISTVIEW
#define KDE_KLISTVIEW

#include <qtc/qtc_types.h>
#include <qtc/qt_QListView.h>

#include <kdec/kde_types.h>

/**
*
 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).

 There is a new signal executed(). It gets connected to either
 @ref QListView::clicked() or  @ref QListView::doubleClicked() depending on the KDE
 wide Single Click/Double Click settings. It is strongly recommended that
 you use this signal instead of the above mentioned. This way you dont
 need to care about the current settings.
 If you want to get informed when the user selects something connect to the
 QListView::selectionChanged() signal.

 Drag-and-Drop is supported with the signal @ref #dropped(), just @ref #setAcceptDrops(true)
 and connect it to a suitable slot.
 To see where you are dropping, @ref setDropVisualizer(true).
 And also you'll need @ref acceptDrag(QDropEvent*)

 KListView is drag-enabled, too: to benefit from that you've got derive from it.
 Reimplement @ref dragObject() and (possibly) @ref startDrag(),
 and @ref setDragEnabled(true).

 @version $Id: kde_KListView.h,v 1.5 2002/11/25 12:24:34 rdale Exp $
 
 @short *
 This Widget extends the functionality of QListView to honor the system
 wide settings for Single Click/Double Click mode, AutoSelection and
 ChangeCursorOverLink (TM).
*/
#define KLISTVIEW_Single	QListView::Single
#define KLISTVIEW_Multi	QListView::Multi
#define KLISTVIEW_Extended	QListView::Extended
#define KLISTVIEW_NoSelection	QListView::NoSelection
#define KLISTVIEW_FileManager	0

/** *
 Constructor.

 The parameters @p parent and @p name are handled by
 @ref QListView, as usual.
   
*/
kde_KListView * kde_new_KListView(qt_QWidget * parent, char* name);

/** *
 Destructor.
   
*/
void kde_del_KListView( kde_KListView* p );

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
void kde_KListView_setAcceptDrops(kde_KListView* instPointer,int arg1);

/** *
 This function determines whether the given coordinates are within the
 execute area. The execute area is the part of a @ref QListViewItem where mouse
 clicks or double clicks respectively generate a @ref #executed() signal.
 Depending on @ref QListView::allColumnsShowFocus() this is either the
 whole item or only the first column.

*/
int kde_KListView_isExecuteArea(kde_KListView* instPointer,qt_QPoint* point);

/** *
 Same thing, but from an x coordinate only. This only checks if x is in
 the first column (if all columns don't show focus), without testing if
 the y coordinate is over an item or not.
   
*/
int kde_KListView_isExecuteArea1(kde_KListView* instPointer,int x);

/** *
 Arbitrarily move @p item to @p parent, positioned immediately after item @p after.
   
*/
void kde_KListView_moveItem(kde_KListView* instPointer,qt_QListViewItem * item, qt_QListViewItem * parent, qt_QListViewItem * after);

/** *

*/
qt_QListViewItem * kde_KListView_lastItem(kde_KListView* instPointer);

/** *

*/
qt_QListViewItem * kde_KListView_lastChild(kde_KListView* instPointer);

/** *

*/
int kde_KListView_itemsMovable(kde_KListView* instPointer);

/** *

*/
int kde_KListView_itemsRenameable(kde_KListView* instPointer);

/** *

*/
int kde_KListView_dragEnabled(kde_KListView* instPointer);

/** *

*/
int kde_KListView_autoOpen(kde_KListView* instPointer);

/** *

*/
int kde_KListView_isRenameable(kde_KListView* instPointer,int column);

/** *

*/
int kde_KListView_dropVisualizer(kde_KListView* instPointer);

/** *

*/
int kde_KListView_tooltipColumn(kde_KListView* instPointer);

/** *
 For future expansions.

 Do not use.

   
*/
int kde_KListView_createChildren(kde_KListView* instPointer);

/** *

*/
int kde_KListView_dropHighlighter(kde_KListView* instPointer);

/** *
 The dropVisualizerWidth defaults to 4.

*/
int kde_KListView_dropVisualizerWidth(kde_KListView* instPointer);

/** *

*/
int kde_KListView_selectionModeExt(kde_KListView* instPointer);

/** *
 Returns the index of @p item within the item tree or -1 if
 @p item doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
int kde_KListView_itemIndex(kde_KListView* instPointer,qt_QListViewItem * item);

/** *
 Returns the item of @p index within the item tree or 0 if
 @p index doesn't exist in this list view. This function takes
 all items into account not only the visible ones.
   
*/
qt_QListViewItem * kde_KListView_itemAtIndex(kde_KListView* instPointer,int index);

/** *

   
*/
void kde_KListView_setFullWidth(kde_KListView* instPointer);

/** *
 Let the last column fit exactly all the available width.
   
*/
void kde_KListView_setFullWidth1(kde_KListView* instPointer,int fullWidth);

/** *
 Returns whether the last column is set to fit the available width.
   
*/
int kde_KListView_fullWidth(kde_KListView* instPointer);

/** *
 Reimplemented for full width support
   
*/
int kde_KListView_addColumn(kde_KListView* instPointer,qt_QString * label, int width);

/** *
 Reimplemented for full width support
   
*/
int kde_KListView_addColumn1(kde_KListView* instPointer,qt_QIconSet* iconset, qt_QString * label, int width);

/** *
 Reimplemented for full width support
   
*/
void kde_KListView_removeColumn(kde_KListView* instPointer,int index);

/** *
 sets the alternate background background color.
 This only has an effect if the items are KListViewItems

*/
void kde_KListView_setAlternateBackground(kde_KListView* instPointer,qt_QColor * c);

/** *

*/
qt_QColor * kde_KListView_alternateBackground(kde_KListView* instPointer);

/** *
 Saves the list view's layout (column widtsh, column order, sort column)
 to a KConfig group

*/
void kde_KListView_saveLayout(kde_KListView* instPointer,kde_KConfig* config, qt_QString * group);

/** *
 Reads the list view's layout from a KConfig group as stored with
 @ref #saveLayout

*/
void kde_KListView_restoreLayout(kde_KListView* instPointer,kde_KConfig* config, qt_QString * group);

/** *
 Reimplemented to remember the current sort column and order
   
*/
void kde_KListView_setSorting(kde_KListView* instPointer,int column, int ascending);

/** *

*/
int kde_KListView_columnSorted(kde_KListView* instPointer);

/** *

*/
int kde_KListView_ascendingSort(kde_KListView* instPointer);

/** *
 Rename column @p c of @p item.
   
*/
void kde_KListView_rename(kde_KListView* instPointer,qt_QListViewItem * item, int c);

/** *
 By default, if you called setItemsRenameable(true),
 only the first column is renameable.
 Use this function to enable the feature on other columns.

 If you want more intelligent (dynamic) selection,
 you'll have to derive from KListView,
 and override @ref rename() and call only call it
 if you want the item to be renamed.

*/
void kde_KListView_setRenameable(kde_KListView* instPointer,int column, int yesno);

/** *
 Set whether items in the list view can be moved.
 It is enabled by default.

*/
void kde_KListView_setItemsMovable(kde_KListView* instPointer,int b);

/** *
 Enables inplace-renaming of items.
 It is disabled by default.

*/
void kde_KListView_setItemsRenameable(kde_KListView* instPointer,int b);

/** *
 Enable/Disable the dragging of items.
 It is disabled by default.
   
*/
void kde_KListView_setDragEnabled(kde_KListView* instPointer,int b);

/** *
 Enable/Disable AutoOpen (not implemented currently).
   
*/
void kde_KListView_setAutoOpen(kde_KListView* instPointer,int b);

/** *
 Enable/Disable the drawing of a drop-visualizer
 (a bar that shows where a dropped item would be inserted).
 It is enabled by default, if dragging is enabled
   
*/
void kde_KListView_setDropVisualizer(kde_KListView* instPointer,int b);

/** *
 Set the width of the (default) drop-visualizer.
 If you don't call this method, the width is set to 4.
   
*/
void kde_KListView_setDropVisualizerWidth(kde_KListView* instPointer,int w);

/** *
 Set which column should be used for automatic tooltips.

*/
void kde_KListView_setTooltipColumn(kde_KListView* instPointer,int column);

/** *
 Enable/Disable the drawing of a drop-highlighter
 (a rectangle around the item under the mouse cursor).
 It is disabled by default.
   
*/
void kde_KListView_setDropHighlighter(kde_KListView* instPointer,int b);

/** *
 For future expansions.

 Do not use.

   
*/
void kde_KListView_setCreateChildren(kde_KListView* instPointer,int b);

/** *
 Set the selection mode.

 A different name was chosen to avoid API-clashes with @ref QListView::setSelectionMode().
   
*/
void kde_KListView_setSelectionModeExt(kde_KListView* instPointer,int mode);

/** *
 Enable/disable tabbing between editable cells

*/
void kde_KListView_setTabOrderedRenaming(kde_KListView* instPointer,int b);

/** *
 Returns whether tab ordered renaming is enabled

*/
int kde_KListView_tabOrderedRenaming(kde_KListView* instPointer);

/** *
 Determine whether a drop on position @p p would count as
 being above or below the QRect @p rect.

*/
int kde_KListView_below(kde_KListView* instPointer,qt_QRect* rect, qt_QPoint* p);

/** *
 An overloaded version of below(const QRect&, const QPoint&).

 It differs from the above only in what arguments it takes.

*/
int kde_KListView_below1(kde_KListView* instPointer,qt_QListViewItem * i, qt_QPoint* p);

/** *
 Reimplemented to reload the alternate background in palette changes.

   
*/
int kde_KListView_event(kde_KListView* instPointer,qt_QEvent * arg1);

/** *
 Emit signal @ref #executed.

   
*/
void kde_KListView_emitExecute(kde_KListView* instPointer,qt_QListViewItem * item, qt_QPoint* pos, int c);

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *

*/
qt_QString * kde_KListView_tooltip(kde_KListView* instPointer,qt_QListViewItem * item, int column);

/** *

*/
int kde_KListView_showTooltip(kde_KListView* instPointer,qt_QListViewItem * item, qt_QPoint* pos, int column);

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *

*/
qt_QDragObject* kde_KListView_dragObject(kde_KListView* instPointer);

/** *

*/
int kde_KListView_acceptDrag(kde_KListView* instPointer,qt_QDropEvent* event);

/** *
 Paint the drag line. If painter is null, don't try to :)

 If after == 0 then the marker should be drawn at the top.

*/
qt_QRect* kde_KListView_drawDropVisualizer(kde_KListView* instPointer,qt_QPainter * p, qt_QListViewItem * parent, qt_QListViewItem * after);

/** *
 Paint the drag rectangle. If painter is null, don't try to :)

*/
qt_QRect* kde_KListView_drawItemHighlighter(kde_KListView* instPointer,qt_QPainter * painter, qt_QListViewItem * item);

/** *
 This method calls @ref dragObject() and starts the drag.

 Reimplement it to do fancy stuff like setting a pixmap or
 using a non-default DragMode
   
*/
void kde_KListView_startDrag(kde_KListView* instPointer);

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/

/** *
 In FileManager selection mode: explicitely activate the mode
 in which the current item is automatically selected.
   
*/
void kde_KListView_activateAutomaticSelection(kde_KListView* instPointer);

/** *
 In FileManager selection mode: explicitely deactivate the mode
 in which the current item is automatically selected.
   
*/
void kde_KListView_deactivateAutomaticSelection(kde_KListView* instPointer);

/** *
 In FileManager selection mode: return whether it is currently in the mode
 where the current item is selected automatically.
 Returns false if items were selected explicitely, e.g. using the mouse.
   
*/
int kde_KListView_automaticSelection(kde_KListView* instPointer);

/** *
 Reimplemented for setFullWidth()
   
*/

/** *
 Handle dropEvent when itemsMovable() is set to true.
   
*/

/** *
 Where is the nearest QListViewItem that I'm going to drop?
   
*/
void kde_KListView_findDrop(kde_KListView* instPointer,qt_QPoint* pos, qt_QListViewItem* parent, qt_QListViewItem* after);

/** *
 A special keyPressEvent (for FileManager selection mode).
   
*/

/** *
 Convert the depth of an item into its indentation in pixels
   
*/
int kde_KListView_depthToPixels(kde_KListView* instPointer,int depth);
void kde_KListView_virtual_hook(kde_KListView* instPointer,int identifier, void* data);

/** *
 Update internal settings whenever the global ones change.

   
*/
void kde_KListView_slotSettingsChanged(kde_KListView* instPointer,int arg1);
void kde_KListView_slotMouseButtonClicked(kde_KListView* instPointer,int btn, qt_QListViewItem * item, qt_QPoint* pos, int c);
void kde_KListView_doneEditing(kde_KListView* instPointer,qt_QListViewItem * item, int row);

/** *
 Repaint the rect where I was drawing the drop line.
   
*/
void kde_KListView_cleanDropVisualizer(kde_KListView* instPointer);

/** *
 Repaint the rect where I was drawing the drop rectangle.
   
*/
void kde_KListView_cleanItemHighlighter(kde_KListView* instPointer);

/** *
 Emit the @ref contextMenu signal. This slot is for mouse actions.
   
*/
void kde_KListView_emitContextMenu(kde_KListView* instPointer,qt_QListViewItem * arg1, qt_QPoint* arg2, int arg3);

/** *
 Emit the @ref #contextMenu signal. This slot is for key presses.
   
*/
void kde_KListView_emitContextMenu1(kde_KListView* instPointer,kde_KListView* arg1, qt_QListViewItem * arg2);

/** *
 Accessory slot for AutoSelect

   
*/
void kde_KListView_slotOnItem(kde_KListView* instPointer,qt_QListViewItem * item);

/** *
 Accessory slot for AutoSelect/ChangeCursorOverItem

   
*/
void kde_KListView_slotOnViewport(kde_KListView* instPointer);

/** *
 Process AutoSelection.

   
*/
void kde_KListView_slotAutoSelect(kde_KListView* instPointer);

/** *
 Reacts to header changes in full width mode

   
*/
void kde_KListView_slotHeaderChanged(kde_KListView* instPointer);

#endif
