/***************************************************************************
                            kde_KKeyDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KKEYDIALOG
#define KDE_KKEYDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KActionCollection, KAccel, and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. The most common and most encouraged use is with KActionCollection.

 <pre>
 KKeyDialog::configure( actionCollection() );
 </pre>

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: kde_KKeyDialog.h,v 1.4 2002/11/25 12:24:34 rdale Exp $

 @short Dialog for configuration of @ref KActionCollection, @ref KAccel, and @ref KGlobalAccel.

*/

/** *
 Constructs a KKeyDialog called @p name as a child of @p parent.
 Set @p bAllowLetterShortcuts to false if unmodified alphanumeric
 keys ('A', '1', etc.) are not permissible shortcuts.
	 
*/
kde_KKeyDialog * kde_new_KKeyDialog(int bAllowLetterShortcuts, qt_QWidget * parent, char* name);

/** *
 Destructor. Deletes all resources used by a KKeyDialog object.
	 
*/
void kde_del_KKeyDialog( kde_KKeyDialog* p );

/** *
 Insert an action collection, i.e. add all its actions to the ones
 displayed by the dialog.
 This method can be useful in applications following the document/view
 design, with actions in both the document and the view.
 Simply call insert with the action collections of each one in turn.

*/
int kde_KKeyDialog_insert(kde_KKeyDialog* instPointer,kde_KActionCollection* arg1);

/** *
 Insert an action collection, i.e. add all its actions to the ones
 displayed by the dialog.
 This method can be useful in applications following the document/view
 design, with actions in both the document and the view.
 Simply call insert with the action collections of each one in turn.

*/
int kde_KKeyDialog_insert1(kde_KKeyDialog* instPointer,kde_KActionCollection* arg1, qt_QString * title);
int kde_KKeyDialog_configure(kde_KKeyDialog* instPointer,int bSaveSettings);

/** *
 Commit key setting changes so that changed settings actually become active.
 This method is implicitly called from #configure if
 @p bSaveSettings is true.
	 
*/
void kde_KKeyDialog_commitChanges(kde_KKeyDialog* instPointer);

/** *
 Pops up a modal dialog for configuring key settings. The new
 shortcut settings will be active if the user presses OK.  If
 @p bSaveSettings is true, the settings will also be saved back to
 the *uirc file which they were intially read from.

*/
int kde_KKeyDialog_configure1( kde_KActionCollection* coll, qt_QWidget * parent, int bSaveSettings);

/** *
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function, except that settings
 are saved to a *.rc file using KConfig.
	 
*/
int kde_KKeyDialog_configure2( kde_KAccel* keys, qt_QWidget * parent, int bSaveSettings);

/** *
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.
	 
*/
int kde_KKeyDialog_configure3( kde_KGlobalAccel* keys, qt_QWidget * parent, int bSaveSettings);

/** *
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
int kde_KKeyDialog_configure4( kde_KActionCollection* coll, int bAllowLetterShortcuts, qt_QWidget * parent, int bSaveSettings);

/** *
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
int kde_KKeyDialog_configure5( kde_KAccel* keys, int bAllowLetterShortcuts, qt_QWidget * parent, int bSaveSettings);

/** *
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
int kde_KKeyDialog_configure6( kde_KGlobalAccel* keys, int bAllowLetterShortcuts, qt_QWidget * parent, int bSaveSettings);

/** *

 Please use @ref KKeyDialog::configure instead
	 
*/
int kde_KKeyDialog_configureKeys( kde_KAccel* keys, int save_settings, qt_QWidget * parent);

/** *

 Please use @ref KKeyDialog::configure instead
	 
*/
int kde_KKeyDialog_configureKeys1( kde_KGlobalAccel* keys, int save_settings, qt_QWidget * parent);

/** *

 Please use @ref KKeyDialog::configure instead
	 
*/
int kde_KKeyDialog_configureKeys2( kde_KActionCollection* coll, qt_QString * arg1, int save_settings, qt_QWidget * parent);
void kde_KKeyDialog_virtual_hook(kde_KKeyDialog* instPointer,int identifier, void* data);

#endif
