/***************************************************************************
                            kde_KDataToolInfo.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDATATOOLINFO
#define KDE_KDATATOOLINFO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is a convenience class for @ref KService. You can use it if you have
 a KService describing a KDataTool. In this case the KDataToolInfo class
 is more convenient to work with.

 Especially useful is the method @ref #createTool which creates the datatool
 described by the service.
 
 @short *
 This is a convenience class for @ref KService.
*/

/** *
 Create an invalid KDataToolInfo.
     
*/
kde_KDataToolInfo * kde_new_KDataToolInfo();

/** *
 Create a valid KDataToolInfo.
     
*/
//kde_KDataToolInfo * kde_new_KDataToolInfo1(kde_KServicePtr* service, kde_KInstance* instance);

/** *
 Copy constructor.
     
*/
kde_KDataToolInfo * kde_new_KDataToolInfo2(kde_KDataToolInfo* info);

/** *

*/
qt_QString * kde_KDataToolInfo_dataType(kde_KDataToolInfo* instPointer);

/** *

 The mimetypes are only used if the @ref #dataType can be used to store
 different mimetypes. For example in a "QString" you could save "text/plain"
 or "text/html" or "text/xml".
     
*/
qt_QStringList* kde_KDataToolInfo_mimeTypes(kde_KDataToolInfo* instPointer);

/** *

*/
int kde_KDataToolInfo_isReadOnly(kde_KDataToolInfo* instPointer);

/** *

     
*/
qt_QPixmap * kde_KDataToolInfo_icon(kde_KDataToolInfo* instPointer);

/** *

     
*/
qt_QPixmap * kde_KDataToolInfo_miniIcon(kde_KDataToolInfo* instPointer);

/** *

*/
qt_QString * kde_KDataToolInfo_iconName(kde_KDataToolInfo* instPointer);

/** *

 This list comes from the Comment field of the tool's desktop file
 (so that it can be translated).

 Each of the strings returned corresponds to a string in the list returned by
 @ref #commands.
     
*/
qt_QStringList* kde_KDataToolInfo_userCommands(kde_KDataToolInfo* instPointer);

/** *

 This list comes from the Commands field of the tool's desktop file.

 Each of the strings returned corresponds to a string in the list returned by
 @ref #userCommands.
     
*/
qt_QStringList* kde_KDataToolInfo_commands(kde_KDataToolInfo* instPointer);

/** *
 Creates the data tool described by this KDataToolInfo.

*/
kde_KDataTool* kde_KDataToolInfo_createTool(kde_KDataToolInfo* instPointer,qt_QObject * parent, char* name);
//kde_KService_Ptr* kde_KDataToolInfo_service(kde_KDataToolInfo* instPointer);
kde_KInstance* kde_KDataToolInfo_instance(kde_KDataToolInfo* instPointer);

/** *
 A DataToolInfo may be invalid if the @ref KService passed to its constructor does
 not feature the service type "KDataTool".
     
*/
int kde_KDataToolInfo_isValid(kde_KDataToolInfo* instPointer);

#endif
