/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DefaultActionListener;
import sun.plugin.usability.PluginSysAction;
import sun.plugin.usability.PluginSysUtil;
import sun.plugin.usability.PluginUIManager;
import sun.plugin.usability.Trace;

public class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    private static String confirmDialogTitle;
    private static String inputDialogTitle;
    private static String messageDialogTitle;
    private static String exceptionDialogTitle;
    private static String optionDialogTitle;
    private static String aboutDialogTitle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$plugin$usability$DialogFactory;

    public static Icon loadIcon() {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/usability/logo.jpg");
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    return imageIcon;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return icon;
    }

    public static void showAboutPluginDialog() {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(){

                    public Object execute() throws Exception {
                        DialogFactory.showAboutPluginDialogImpl();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static void showAboutPluginDialogImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object var5_5;
                LookAndFeel lookAndFeel = null;
                try {
                    lookAndFeel = PluginUIManager.setTheme();
                    JOptionPane jOptionPane = new JOptionPane();
                    jOptionPane.setMessageType(-1);
                    jOptionPane.setOptionType(-1);
                    jOptionPane.setWantsInput(false);
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/usability/about.gif");
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    DialogFactory.showDialog(jOptionPane, null, aboutDialogTitle, imageIcon, false);
                    var5_5 = null;
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    PluginUIManager.restoreTheme(lookAndFeel);
                    throw throwable;
                }
                PluginUIManager.restoreTheme(lookAndFeel);
                return var5_5;
            }
        });
    }

    public static int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(null, object, confirmDialogTitle);
    }

    public static int showConfirmDialog(Component component, Object object) {
        return DialogFactory.showConfirmDialog(component, object, confirmDialogTitle);
    }

    public static String showInputDialog(Object object) {
        return DialogFactory.showInputDialog(null, object, inputDialogTitle);
    }

    public static String showInputDialog(Component component, Object object) {
        return DialogFactory.showInputDialog(component, object, inputDialogTitle);
    }

    public static void showInformationDialog(Object object) {
        DialogFactory.showInformationDialog(null, object, messageDialogTitle);
    }

    public static void showInformationDialog(Component component, Object object) {
        DialogFactory.showInformationDialog(component, object, messageDialogTitle);
    }

    public static void showErrorDialog(String string) {
        DialogFactory.showErrorDialog(null, string, messageDialogTitle);
    }

    public static void showErrorDialog(Component component, String string) {
        DialogFactory.showErrorDialog(component, string, messageDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable) {
        DialogFactory.showExceptionDialog(null, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable) {
        DialogFactory.showExceptionDialog(component, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static int showConfirmDialog(Object object, String string) {
        return DialogFactory.showConfirmDialog(null, object, string);
    }

    public static int showConfirmDialog(final Component component, final Object object, final String string) {
        try {
            return (Integer)PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showConfirmDialogImpl(component, object, string));
                }
            });
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showConfirmDialogImpl(Component component, Object object, String string) {
        int n;
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JButton jButton = new JButton(ResourceHandler.getMessage("usability.confirm.yes"));
            JButton jButton2 = new JButton(ResourceHandler.getMessage("usability.confirm.no"));
            jButton.setMnemonic(ResourceHandler.getAcceleratorKey("usability.confirm.yes"));
            jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("usability.confirm.no"));
            Object[] objectArray = new Object[]{jButton, jButton2};
            if (string == null) {
                string = confirmDialogTitle;
            }
            n = DialogFactory.showOptionDialog(component, 4, object, string, objectArray, objectArray[0]);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            PluginUIManager.restoreTheme(lookAndFeel);
            throw throwable;
        }
        PluginUIManager.restoreTheme(lookAndFeel);
        return n;
    }

    public static int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, object, string, objectArray, object2);
    }

    public static int showOptionDialog(Component component, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(component, 5, object, string, objectArray, object2);
    }

    public static int showOptionDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, n, object, string, objectArray, object2);
    }

    public static int showOptionDialog(final Component component, final int n, final Object object, final String string, final Object[] objectArray, final Object object2) {
        Integer n2 = null;
        try {
            n2 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return (Integer)PluginSysUtil.execute(new PluginSysAction(this){
                            private final /* synthetic */ 5 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public Object execute() throws Exception {
                                return new Integer(DialogFactory.access$1000(5.access$400(this.this$0), 5.access$500(this.this$0), 5.access$600(this.this$0), 5.access$700(this.this$0), 5.access$800(this.this$0), 5.access$900(this.this$0)));
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return null;
                    }
                }

                static /* synthetic */ Component access$400(5 var0) {
                    return var0.component;
                }

                static /* synthetic */ int access$500(5 var0) {
                    return var0.n;
                }

                static /* synthetic */ Object access$600(5 var0) {
                    return var0.object;
                }

                static /* synthetic */ String access$700(5 var0) {
                    return var0.string;
                }

                static /* synthetic */ Object[] access$800(5 var0) {
                    return var0.objectArray;
                }

                static /* synthetic */ Object access$900(5 var0) {
                    return var0.object2;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 1;
        }
        if (n2 != null) {
            return n2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showOptionDialogImpl(Component component, int n, Object object, String string, Object[] objectArray, Object object2) {
        int n2;
        LookAndFeel lookAndFeel = null;
        try {
            Object object3;
            lookAndFeel = PluginUIManager.setTheme();
            int n3 = -1;
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(object2);
            jOptionPane.setWantsInput(false);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = optionDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4) && (object3 = jOptionPane.getValue()) != null) {
                int n4 = 0;
                while (n4 < objectArray.length) {
                    if (objectArray[n4].equals(object3)) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                Trace.msgPrintln("dialogfactory.user.selected", new Object[]{new Integer(n3)});
            }
            n2 = n3;
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            PluginUIManager.restoreTheme(lookAndFeel);
            throw throwable;
        }
        PluginUIManager.restoreTheme(lookAndFeel);
        return n2;
    }

    public static String showInputDialog(Object object, String string) {
        return DialogFactory.showInputDialog(null, object, string);
    }

    public static String showInputDialog(final Component component, final Object object, final String string) {
        try {
            return (String)PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    return DialogFactory.showInputDialogImpl(component, object, string);
                }
            });
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String showInputDialogImpl(Component component, Object object, String string) {
        Object object2;
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            Object object3 = null;
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(3);
            jOptionPane.setOptionType(2);
            jOptionPane.setWantsInput(true);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = inputDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4) && (object2 = jOptionPane.getInputValue()) != null) {
                if (object2 instanceof String) {
                    object3 = object2.toString();
                }
                Trace.msgPrintln("dialogfactory.user.typed", new Object[]{object3});
            }
            object2 = object3;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            PluginUIManager.restoreTheme(lookAndFeel);
            throw throwable;
        }
        PluginUIManager.restoreTheme(lookAndFeel);
        return object2;
    }

    private static void showMessageDialog(int n, Object object, String string, boolean bl) {
        DialogFactory.showMessageDialog(null, n, object, string, bl);
    }

    private static void showMessageDialog(final Component component, final int n, final Object object, final String string, final boolean bl) {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(){

                    public Object execute() throws Exception {
                        DialogFactory.showMessageDialogImpl(component, n, object, string, bl);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageDialogImpl(Component component, int n, Object object, String string, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Object object2 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = messageDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string, object2, bl);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            PluginUIManager.restoreTheme(lookAndFeel);
            throw throwable;
        }
        PluginUIManager.restoreTheme(lookAndFeel);
    }

    public static void showInformationDialog(Object object, String string) {
        DialogFactory.showInformationDialog(null, object, string);
    }

    public static void showInformationDialog(Component component, Object object, String string) {
        DialogFactory.showMessageDialog(component, 2, object, string, true);
    }

    public static void showErrorDialog(String string, String string2) {
        DialogFactory.showErrorDialog(null, string, string2);
    }

    public static void showErrorDialog(Component component, String string, String string2) {
        DialogFactory.showMessageDialog(component, 1, string, string2, true);
    }

    public static void showExceptionDialog(Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(component, throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialog(null, throwable, string, string2);
    }

    public static void showExceptionDialog(final Component component, final Throwable throwable, final String string, final String string2) {
        block2: {
            try {
                PluginSysUtil.execute(new PluginSysAction(){

                    public Object execute() throws Exception {
                        DialogFactory.showExceptionDialogImpl(component, throwable, string, string2);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showExceptionDialogImpl(Component component, Throwable throwable, String string, String string2) {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = PluginUIManager.setTheme();
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(0);
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Component component2 = (Component)DialogFactory.extractMessage(jOptionPane, throwable);
            final JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ResourceHandler.getMessage("usability.moreInfo"));
            jButton.setMnemonic(ResourceHandler.getAcceleratorKey("usability.moreInfo"));
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(jButton);
            final JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton(ResourceHandler.getMessage("usability.lessInfo"));
            jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("usability.lessInfo"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(jButton2);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add(component2, "South");
            final JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel, "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel);
                        jPanel4.add((Component)jPanel2, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel2);
                        jPanel4.add((Component)jPanel, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            Object[] objectArray = new Object[]{DialogFactory.extractMessage(jOptionPane, string), jPanel4};
            if (string2 == null) {
                string2 = exceptionDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string2, objectArray);
            Object var15_14 = null;
        }
        catch (Throwable throwable2) {
            Object var15_15 = null;
            PluginUIManager.restoreTheme(lookAndFeel);
            throw throwable2;
        }
        PluginUIManager.restoreTheme(lookAndFeel);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, true);
    }

    private static boolean showDialog(final JOptionPane jOptionPane, final Component component, final String string, final Object object, final boolean bl) {
        boolean bl2;
        block5: {
            bl2 = true;
            try {
                jOptionPane.setValue(null);
                Runnable runnable = new Runnable(){

                    public void run() {
                        JDialog jDialog = jOptionPane.createDialog(component, string);
                        Object[] objectArray = jOptionPane.getOptions();
                        if (null != objectArray) {
                            DefaultActionListener defaultActionListener = new DefaultActionListener(jDialog, jOptionPane);
                            int n = 0;
                            while (n < objectArray.length) {
                                if (objectArray[n] instanceof JButton) {
                                    JButton jButton = (JButton)objectArray[n];
                                    ActionListener[] actionListenerArray = jButton.getActionListeners();
                                    int n2 = 0;
                                    while (n2 < actionListenerArray.length) {
                                        if (actionListenerArray[n2] instanceof DefaultActionListener) {
                                            jButton.removeActionListener((DefaultActionListener)actionListenerArray[n2]);
                                        }
                                        ++n2;
                                    }
                                    if (jButton.getActionListeners().length == 0) {
                                        jButton.addActionListener(defaultActionListener);
                                    }
                                }
                                ++n;
                            }
                        }
                        jOptionPane.setMessage(object);
                        jDialog.pack();
                        DialogFactory.fixSwingLayoutBug(object);
                        jDialog.pack();
                        jDialog.setResizable(false);
                        jDialog.setModal(bl);
                        jDialog.show();
                        jDialog.toFront();
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    if (bl) {
                        SwingUtilities.invokeAndWait(runnable);
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                    break block5;
                }
                runnable.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl2 = false;
            }
        }
        return bl2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = DialogFactory.extractMessage(jOptionPane, objectArray[n]);
                ++n;
            }
        }
        return objectArray2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static Object formatStringMessage(JOptionPane jOptionPane, String string) {
        int n;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (string == null) {
            string = "null";
        }
        if ((n = string.indexOf("</html>")) == -1) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setColumns(40);
            jTextArea.setAutoscrolls(true);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(jOptionPane.getBackground());
            jTextArea.setText(string);
            return jTextArea;
        }
        if (n + 7 == string.length()) {
            return new JLabel(string);
        }
        Object[] objectArray = new Object[]{new JLabel(string.substring(0, n + 7)), DialogFactory.formatStringMessage(jOptionPane, string.substring(n + 7))};
        return objectArray;
    }

    private static Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea("" + stringWriter.toString());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    private static void fixSwingLayoutBug(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object;
            jTextArea.getUI().getPreferredSize(jTextArea);
            return;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n) {
                DialogFactory.fixSwingLayoutBug(Array.get(object, n2));
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$1000(Component component, int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialogImpl(component, n, object, string, objectArray, object2);
    }

    static {
        $assertionsDisabled = !(class$sun$plugin$usability$DialogFactory == null ? (class$sun$plugin$usability$DialogFactory = DialogFactory.class$("sun.plugin.usability.DialogFactory")) : class$sun$plugin$usability$DialogFactory).desiredAssertionStatus();
        confirmDialogTitle = ResourceHandler.getMessage("usability.confirmDialogTitle");
        inputDialogTitle = ResourceHandler.getMessage("usability.inputDialogTitle");
        messageDialogTitle = ResourceHandler.getMessage("usability.messageDialogTitle");
        exceptionDialogTitle = ResourceHandler.getMessage("usability.exceptionDialogTitle");
        optionDialogTitle = ResourceHandler.getMessage("usability.optionDialogTitle");
        aboutDialogTitle = ResourceHandler.getMessage("usability.aboutDialogTitle");
    }
}

