/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte by) {
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n2 = 0;
        while (n2 < 65536) {
            this.values[n2] = by;
            ++n2;
        }
        n2 = 0;
        while (n2 < 512) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
            ++n2;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] sArray, byte[] byArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        int n2 = 0;
        while (n2 < 512) {
            short s2 = sArray[n2];
            if (s2 < 0 || s2 >= byArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds!");
            }
            ++n2;
        }
        this.indices = sArray;
        this.values = byArray;
        this.isCompact = true;
    }

    public CompactByteArray(String string, String string2) {
        this(Utility.RLEStringToShortArray(string), Utility.RLEStringToByteArray(string2));
    }

    public byte elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char c2, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = by;
        this.touchBlock(c2 >> 7, by);
    }

    public void setElementAt(char n2, char c2, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        int n3 = n2;
        while (n3 <= c2) {
            this.values[n3] = by;
            this.touchBlock(n3 >> 7, by);
            ++n3;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while (n6 < this.indices.length) {
                this.indices[n6] = -1;
                n2 = this.blockTouched(n6) ? 1 : 0;
                if (n2 == 0 && n5 != -1) {
                    this.indices[n6] = n5;
                } else {
                    int n7 = 0;
                    int n8 = 0;
                    n8 = 0;
                    while (n8 < n3) {
                        if (this.hashes[n6] == this.hashes[n8] && CompactByteArray.arrayRegionMatches(this.values, n4, this.values, n7, 128)) {
                            this.indices[n6] = (short)n7;
                            break;
                        }
                        ++n8;
                        n7 += 128;
                    }
                    if (this.indices[n6] == -1) {
                        System.arraycopy(this.values, n4, this.values, n7, 128);
                        this.indices[n6] = (short)n7;
                        this.hashes[n8] = this.hashes[n6];
                        ++n3;
                        if (n2 == 0) {
                            n5 = (short)n7;
                        }
                    }
                }
                ++n6;
                n4 += 128;
            }
            n2 = n3 * 128;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.values, 0, byArray, 0, n2);
            this.values = byArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        int n7 = n2;
        while (n7 < n5) {
            if (byArray[n7] != byArray2[n7 + n6]) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray compactByteArray = (CompactByteArray)super.clone();
            compactByteArray.values = (byte[])this.values.clone();
            compactByteArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactByteArray.hashes = (int[])this.hashes.clone();
            }
            return compactByteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactByteArray compactByteArray = (CompactByteArray)object;
        int n2 = 0;
        while (n2 < 65536) {
            if (this.elementAt((char)n2) != compactByteArray.elementAt((char)n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        int n4 = 0;
        while (n4 < this.values.length) {
            n2 = n2 * 37 + this.values[n4];
            n4 += n3;
        }
        return n2;
    }

    private void expand() {
        if (this.isCompact) {
            this.hashes = new int[512];
            byte[] byArray = new byte[65536];
            int n2 = 0;
            while (n2 < 65536) {
                byte by;
                byArray[n2] = by = this.elementAt((char)n2);
                this.touchBlock(n2 >> 7, by);
                ++n2;
            }
            n2 = 0;
            while (n2 < 512) {
                this.indices[n2] = (short)(n2 << 7);
                ++n2;
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

