/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.rmi.runtime.Log;
import sun.rmi.transport.proxy.HttpSendInputStream;
import sun.rmi.transport.proxy.HttpSendOutputStream;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.security.action.GetPropertyAction;

class HttpSendSocket
extends Socket
implements RMISocketInfo {
    protected String host;
    protected int port;
    protected URL url;
    protected URLConnection conn = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;
    private String lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public HttpSendSocket(String string, int n2, URL uRL) throws IOException {
        super(null);
        if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.VERBOSE)) {
            RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "host = " + string + ", port = " + n2 + ", url = " + uRL);
        }
        this.host = string;
        this.port = n2;
        this.url = uRL;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(String string, int n2) throws IOException {
        this(string, n2, new URL("http", string, n2, "/"));
    }

    public HttpSendSocket(InetAddress inetAddress, int n2) throws IOException {
        this(inetAddress.getHostName(), n2);
    }

    public boolean isReusable() {
        return false;
    }

    public synchronized OutputStream writeNotify() throws IOException {
        if (this.conn != null) {
            throw new IOException("attempt to write on HttpSendSocket after request has been sent");
        }
        this.conn = this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
        this.inNotifier.deactivate();
        this.in = null;
        this.out = this.conn.getOutputStream();
        return this.out;
    }

    public synchronized InputStream readNotify() throws IOException {
        RMIMasterSocketFactory.proxyLog.log(Log.VERBOSE, "sending request and activating input stream");
        this.outNotifier.deactivate();
        this.out.close();
        this.out = null;
        try {
            this.in = this.conn.getInputStream();
        }
        catch (IOException iOException) {
            RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, "failed to get input stream, exception: ", iOException);
            throw new IOException("HTTP request failed");
        }
        String string = this.conn.getContentType();
        if (string == null || !this.conn.getContentType().equals("application/octet-stream")) {
            if (RMIMasterSocketFactory.proxyLog.isLoggable(Log.BRIEF)) {
                String string2 = string == null ? "missing content type in response" + this.lineSeparator : "invalid content type in response: " + string + this.lineSeparator;
                string2 = string2 + "HttpSendSocket.readNotify: response body: ";
                try {
                    String string3;
                    DataInputStream dataInputStream = new DataInputStream(this.in);
                    while ((string3 = dataInputStream.readLine()) != null) {
                        string2 = string2 + string3 + this.lineSeparator;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RMIMasterSocketFactory.proxyLog.log(Log.BRIEF, string2);
            }
            throw new IOException("HTTP request failed");
        }
        return this.in;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    public void setTcpNoDelay(boolean bl2) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean bl2, int n2) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized void setSoTimeout(int n2) throws SocketException {
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }
}

