/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import sun.dc.pr.PRException;
import sun.dc.pr.Rasterizer;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DuctusRenderer;
import sun.java2d.pipe.ShapeDrawPipe;

public class DuctusShapeRenderer
extends DuctusRenderer
implements ShapeDrawPipe {
    CompositePipe outpipe;

    public DuctusShapeRenderer(CompositePipe compositePipe) {
        this.outpipe = compositePipe;
    }

    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        BasicStroke basicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            basicStroke = null;
        }
        this.renderPath(sunGraphics2D, shape, basicStroke);
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.renderPath(sunGraphics2D, shape, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderPath(SunGraphics2D sunGraphics2D, Shape shape, BasicStroke basicStroke) {
        PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
        boolean bl2 = basicStroke != null && sunGraphics2D.strokeHint != 2;
        boolean bl3 = sunGraphics2D.strokeState == 0;
        Rasterizer rasterizer = DuctusRenderer.createShapeRasterizer(pathIterator, sunGraphics2D.transform, basicStroke, bl3, bl2, 0.5f);
        Object object = null;
        byte[] byArray = null;
        try {
            int[] nArray = new int[4];
            rasterizer.getAlphaBox(nArray);
            Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            Rectangle rectangle2 = sunGraphics2D.getCompBounds();
            nArray[0] = Math.max(nArray[0], rectangle2.x);
            nArray[1] = Math.max(nArray[1], rectangle2.y);
            nArray[2] = Math.min(nArray[2], rectangle2.x + rectangle2.width);
            nArray[3] = Math.min(nArray[3], rectangle2.y + rectangle2.height);
            if (nArray[0] >= nArray[2] || nArray[1] >= nArray[3]) {
                return;
            }
            rasterizer.setOutputArea(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            object = this.outpipe.startSequence(sunGraphics2D, shape, rectangle, nArray);
            int n2 = Rasterizer.TILE_SIZE;
            byArray = DuctusRenderer.getAlphaTile();
            int n3 = nArray[1];
            while (n3 < nArray[3]) {
                int n4 = nArray[0];
                while (n4 < nArray[2]) {
                    int n5 = Math.min(n2, nArray[2] - n4);
                    int n6 = Math.min(n2, nArray[3] - n3);
                    int n7 = rasterizer.getTileState();
                    if (n7 == 0 || !this.outpipe.needTile(object, n4, n3, n5, n6)) {
                        rasterizer.nextTile();
                        this.outpipe.skipTile(object, n4, n3);
                    } else {
                        byte[] byArray2;
                        if (n7 == 2) {
                            byArray2 = byArray;
                            DuctusRenderer.getAlpha(rasterizer, byArray, 1, n2, 0);
                        } else {
                            byArray2 = null;
                            rasterizer.nextTile();
                        }
                        this.outpipe.renderPathTile(object, byArray2, 0, n2, n4, n3, n5, n6);
                    }
                    n4 += n2;
                }
                n3 += n2;
            }
            DuctusRenderer.dropRasterizer(rasterizer);
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray == null) return;
        }
        catch (PRException pRException) {
            pRException.printStackTrace();
            return;
        }
        finally {
            DuctusRenderer.dropRasterizer(rasterizer);
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray != null) {
                DuctusRenderer.dropAlphaTile(byArray);
            }
        }
        DuctusRenderer.dropAlphaTile(byArray);
        return;
    }
}

