/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.im.spi.InputMethod;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JFrame;
import sun.awt.InputMethodSupport;
import sun.awt.im.CompositionAreaHandler;
import sun.awt.im.InputContext;
import sun.awt.im.InputMethodJFrame;
import sun.security.action.GetPropertyAction;

public class InputMethodContext
extends InputContext
implements java.awt.im.spi.InputMethodContext {
    private boolean dispatchingCommittedText;
    private CompositionAreaHandler compositionAreaHandler;
    private Object compositionAreaHandlerLock = new Object();
    private static boolean belowTheSpotInputRequested;
    private boolean inputMethodSupportsBelowTheSpot;

    void setInputMethodSupportsBelowTheSpot(boolean bl2) {
        this.inputMethodSupportsBelowTheSpot = bl2;
    }

    private boolean useBelowTheSpotInput() {
        return belowTheSpotInputRequested && this.inputMethodSupportsBelowTheSpot;
    }

    private boolean haveActiveClient() {
        Component component = this.getClientComponent();
        return component != null && component.getInputMethodRequests() != null;
    }

    public void dispatchInputMethodEvent(int n2, AttributedCharacterIterator attributedCharacterIterator, int n3, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        Component component = this.getClientComponent();
        if (component != null) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n2, attributedCharacterIterator, n3, textHitInfo, textHitInfo2);
            if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
                component.dispatchEvent(inputMethodEvent);
            } else {
                this.getCompositionAreaHandler(true).processInputMethodEvent(inputMethodEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void dispatchCommittedText(Component component, AttributedCharacterIterator attributedCharacterIterator, int n2) {
        if (n2 == 0) return;
        if (attributedCharacterIterator.getEndIndex() <= attributedCharacterIterator.getBeginIndex()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        this.dispatchingCommittedText = true;
        try {
            InputMethodRequests inputMethodRequests = component.getInputMethodRequests();
            if (inputMethodRequests != null) {
                int n3 = attributedCharacterIterator.getBeginIndex();
                AttributedCharacterIterator attributedCharacterIterator2 = new AttributedString(attributedCharacterIterator, n3, n3 + n2).getIterator();
                InputMethodEvent inputMethodEvent = new InputMethodEvent(component, 1100, attributedCharacterIterator2, n2, null, null);
                component.dispatchEvent(inputMethodEvent);
            } else {
                char c2 = attributedCharacterIterator.first();
                while (n2-- > 0) {
                    if (c2 == '\uffff') {
                        break;
                    }
                    KeyEvent keyEvent = new KeyEvent(component, 400, l2, 0, 0, c2);
                    component.dispatchEvent(keyEvent);
                    c2 = attributedCharacterIterator.next();
                }
            }
            Object var11_11 = null;
            this.dispatchingCommittedText = false;
            return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.dispatchingCommittedText = false;
            throw throwable;
        }
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputMethodEvent) {
            if (((Component)aWTEvent.getSource()).getInputMethodRequests() == null || this.useBelowTheSpotInput() && !this.dispatchingCommittedText) {
                this.getCompositionAreaHandler(true).processInputMethodEvent((InputMethodEvent)aWTEvent);
            }
        } else if (!this.dispatchingCommittedText) {
            super.dispatchEvent(aWTEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositionAreaHandler getCompositionAreaHandler(boolean bl2) {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler == null) {
                this.compositionAreaHandler = new CompositionAreaHandler(this);
            }
            this.compositionAreaHandler.setClientComponent(this.getClientComponent());
            if (bl2) {
                this.compositionAreaHandler.grabCompositionArea(false);
            }
            return this.compositionAreaHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grabCompositionArea(boolean bl2) {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler != null) {
                this.compositionAreaHandler.grabCompositionArea(bl2);
            } else {
                CompositionAreaHandler.closeCompositionArea();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCompositionArea() {
        Object object = this.compositionAreaHandlerLock;
        synchronized (object) {
            if (this.compositionAreaHandler != null) {
                this.compositionAreaHandler.releaseCompositionArea();
            }
        }
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        return this.getReq().getTextLocation(textHitInfo);
    }

    public TextHitInfo getLocationOffset(int n2, int n3) {
        return this.getReq().getLocationOffset(n2, n3);
    }

    public int getInsertPositionOffset() {
        return this.getReq().getInsertPositionOffset();
    }

    public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getCommittedText(n2, n3, attributeArray);
    }

    public int getCommittedTextLength() {
        return this.getReq().getCommittedTextLength();
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().cancelLatestCommittedText(attributeArray);
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getReq().getSelectedText(attributeArray);
    }

    private InputMethodRequests getReq() {
        if (this.haveActiveClient() && !this.useBelowTheSpotInput()) {
            return this.getClientComponent().getInputMethodRequests();
        }
        return this.getCompositionAreaHandler(false);
    }

    public Window createInputMethodWindow(String string, boolean bl2) {
        InputMethodContext inputMethodContext = bl2 ? this : null;
        return InputMethodContext.createInputMethodWindow(string, inputMethodContext, false);
    }

    public JFrame createInputMethodJFrame(String string, boolean bl2) {
        InputMethodContext inputMethodContext = bl2 ? this : null;
        return (JFrame)InputMethodContext.createInputMethodWindow(string, inputMethodContext, true);
    }

    static Window createInputMethodWindow(String string, InputContext inputContext, boolean bl2) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (bl2) {
            return new InputMethodJFrame(string, inputContext);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof InputMethodSupport) {
            return ((InputMethodSupport)((Object)toolkit)).createInputMethodWindow(string, inputContext);
        }
        throw new InternalError("Input methods must be supported");
    }

    public void enableClientWindowNotification(InputMethod inputMethod, boolean bl2) {
        super.enableClientWindowNotification(inputMethod, bl2);
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.awt.im.style", null));
        if (string == null) {
            Toolkit.getDefaultToolkit();
            string = Toolkit.getProperty("java.awt.im.style", null);
        }
        belowTheSpotInputRequested = "below-the-spot".equals(string);
    }
}

