/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

public class TransferHandler
implements Serializable {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static final int LINK = 0x40000000;
    private String propertyName;
    private static SwingDragGestureRecognizer recognizer = null;
    private static DropTargetListener dropLinkage = null;
    static final Action cutAction = new TransferAction("cut");
    static final Action copyAction = new TransferAction("copy");
    static final Action pasteAction = new TransferAction("paste");
    static /* synthetic */ Class class$java$awt$dnd$DropTargetListener;

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public TransferHandler(String string) {
        this.propertyName = string;
    }

    protected TransferHandler() {
        this(null);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n2) {
        int n3 = this.getSourceActions(jComponent);
        int n4 = n3 & n2;
        if (!(inputEvent instanceof MouseEvent)) {
            n4 = 0;
        }
        if (n4 != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(jComponent, (MouseEvent)inputEvent, n3, n4);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n2) {
        boolean bl2 = false;
        Transferable transferable = null;
        int n3 = this.getSourceActions(jComponent) & n2;
        if (n3 != 0 && (transferable = this.createTransferable(jComponent)) != null) {
            clipboard.setContents(transferable, null);
            bl2 = true;
        }
        if (bl2) {
            this.exportDone(jComponent, transferable, n3);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                try {
                    Object object = transferable.getTransferData(dataFlavor);
                    Object[] objectArray = new Object[]{object};
                    method.invoke(jComponent, objectArray);
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
        }
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], dataFlavorArray);
            if (dataFlavor != null) {
                return true;
            }
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return 1;
        }
        return 0;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return null;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return new PropertyTransferable(propertyDescriptor, jComponent);
        }
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n2) {
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent jComponent) {
        BeanInfo beanInfo;
        if (this.propertyName == null) {
            return null;
        }
        Class clazz = jComponent.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            Class[] classArray;
            Method method;
            if (this.propertyName.equals(propertyDescriptorArray[n2].getName()) && (method = propertyDescriptorArray[n2].getReadMethod()) != null && ((classArray = method.getParameterTypes()) == null || classArray.length == 0)) {
                return propertyDescriptorArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private DataFlavor getPropertyDataFlavor(Class clazz, DataFlavor[] dataFlavorArray) {
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if ("application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && clazz.isAssignableFrom(dataFlavor.getRepresentationClass())) {
                return dataFlavor;
            }
            ++n2;
        }
        return null;
    }

    private static DropTargetListener getDropTargetListener() {
        if (dropLinkage == null) {
            dropLinkage = new DropHandler();
        }
        return dropLinkage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TransferAction
    extends AbstractAction
    implements UIResource {
        private boolean canAccessSystemClipboard = true;
        private static Object SandboxClipboardKey = new Object();

        TransferAction(String string) {
            super(string);
            this.canAccessSystemClipboard();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                TransferHandler transferHandler = jComponent.getTransferHandler();
                Clipboard clipboard = this.getClipboard(jComponent);
                String string = (String)this.getValue("Name");
                if (clipboard != null && transferHandler != null && string != null) {
                    Transferable transferable;
                    if ("cut".equals(string)) {
                        transferHandler.exportToClipboard(jComponent, clipboard, 2);
                    } else if ("copy".equals(string)) {
                        transferHandler.exportToClipboard(jComponent, clipboard, 1);
                    } else if ("paste".equals(string) && (transferable = clipboard.getContents(null)) != null) {
                        transferHandler.importData(jComponent, transferable);
                    }
                }
            }
        }

        private Clipboard getClipboard(JComponent jComponent) {
            if (this.canAccessSystemClipboard()) {
                return jComponent.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }

        private boolean canAccessSystemClipboard() {
            if (this.canAccessSystemClipboard) {
                if (GraphicsEnvironment.isHeadless()) {
                    this.canAccessSystemClipboard = false;
                    return false;
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkSystemClipboardAccess();
                        return true;
                    }
                    catch (SecurityException securityException) {
                        this.canAccessSystemClipboard = false;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n2, int n3) {
            this.setComponent(jComponent);
            this.setSourceActions(n2);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n3, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Transferable transferable = transferHandler.createTransferable(jComponent);
            if (transferable != null) {
                this.scrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    jComponent.setAutoscrolls(this.scrolls);
                }
            }
            transferHandler.exportDone(jComponent, null, 0);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            if (dragSourceDropEvent.getDropSuccess()) {
                jComponent.getTransferHandler().exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                jComponent.getTransferHandler().exportDone(jComponent, null, 0);
            }
            jComponent.setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class DropHandler
    implements DropTargetListener,
    Serializable {
        private boolean canImport;

        private DropHandler() {
        }

        private boolean actionSupported(int n2) {
            return (n2 & 0x40000003) != 0;
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            JComponent jComponent = (JComponent)dropTargetDragEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            this.canImport = transferHandler != null && transferHandler.canImport(jComponent, dataFlavorArray);
            int n2 = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n2)) {
                dropTargetDragEvent.acceptDrag(n2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            int n2 = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n2)) {
                dropTargetDragEvent.acceptDrag(n2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n2 = dropTargetDropEvent.getDropAction();
            JComponent jComponent = (JComponent)dropTargetDropEvent.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            if (this.canImport && transferHandler != null && this.actionSupported(n2)) {
                dropTargetDropEvent.acceptDrop(n2);
                try {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    dropTargetDropEvent.dropComplete(transferHandler.importData(jComponent, transferable));
                }
                catch (RuntimeException runtimeException) {
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            int n2 = dropTargetDragEvent.getDropAction();
            if (this.canImport && this.actionSupported(n2)) {
                dropTargetDragEvent.acceptDrag(n2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    static class SwingDropTarget
    extends DropTarget
    implements UIResource {
        private EventListenerList listenerList;

        SwingDropTarget(JComponent jComponent) {
            this.setComponent(jComponent);
            try {
                super.addDropTargetListener(TransferHandler.getDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {}
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = TransferHandler.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
        }

        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(class$java$awt$dnd$DropTargetListener == null ? (class$java$awt$dnd$DropTargetListener = TransferHandler.class$("java.awt.dnd.DropTargetListener")) : class$java$awt$dnd$DropTargetListener, dropTargetListener);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n2 + 1]).dragEnter(dropTargetDragEvent);
                    }
                    n2 -= 2;
                }
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n2 + 1]).dragOver(dropTargetDragEvent);
                    }
                    n2 -= 2;
                }
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            super.dragExit(dropTargetEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n2 + 1]).dragExit(dropTargetEvent);
                    }
                    n2 -= 2;
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n2 + 1]).drop(dropTargetDropEvent);
                    }
                    n2 -= 2;
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            super.dropActionChanged(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                int n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == (class$java$awt$dnd$DropTargetListener == null ? TransferHandler.class$("java.awt.dnd.DropTargetListener") : class$java$awt$dnd$DropTargetListener)) {
                        ((DropTargetListener)objectArray[n2 + 1]).dropActionChanged(dropTargetDragEvent);
                    }
                    n2 -= 2;
                }
            }
        }
    }

    static class PropertyTransferable
    implements Transferable {
        JComponent component;
        PropertyDescriptor property;

        PropertyTransferable(PropertyDescriptor propertyDescriptor, JComponent jComponent) {
            this.property = propertyDescriptor;
            this.component = jComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Class clazz = this.property.getPropertyType();
            String string = "application/x-java-jvm-local-objectref;class=" + clazz.getName();
            try {
                dataFlavorArray[0] = new DataFlavor(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class clazz = this.property.getPropertyType();
            return "application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass().isAssignableFrom(clazz);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            Method method = this.property.getReadMethod();
            Object object = null;
            try {
                object = method.invoke(this.component, null);
            }
            catch (Exception exception) {
                throw new IOException("Property read failed: " + this.property.getName());
            }
            return object;
        }
    }
}

