/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final String uiClassID = "InternalFrameUI";
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected boolean closable;
    protected boolean isClosed;
    protected boolean maximizable;
    protected boolean isMaximum;
    protected boolean iconable;
    protected boolean isIcon;
    protected boolean resizable;
    protected boolean isSelected;
    protected Icon frameIcon;
    protected String title;
    protected JDesktopIcon desktopIcon;
    private boolean opened;
    private Rectangle normalBounds = null;
    private int defaultCloseOperation = 2;
    private Component lastFocusOwner;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String TITLE_PROPERTY = "title";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_ICON_PROPERTY = "icon";
    boolean isDragging = false;
    boolean danger = false;
    static /* synthetic */ Class class$javax$swing$event$InternalFrameListener;

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl2) {
        this(string, bl2, false, false, false);
    }

    public JInternalFrame(String string, boolean bl2, boolean bl3) {
        this(string, bl2, bl3, false, false);
    }

    public JInternalFrame(String string, boolean bl2, boolean bl3, boolean bl4) {
        this(string, bl2, bl3, bl4, false);
    }

    public JInternalFrame(String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.setRootPane(this.createRootPane());
        this.getGlassPane().setVisible(true);
        this.setLayout(new BorderLayout());
        this.title = string;
        this.resizable = bl2;
        this.closable = bl3;
        this.maximizable = bl4;
        this.isMaximum = false;
        this.iconable = bl5;
        this.isIcon = false;
        this.setVisible(false);
        this.setRootPaneCheckingEnabled(true);
        this.desktopIcon = new JDesktopIcon(this);
        this.updateUI();
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl2 = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(internalFrameUI);
            Object var4_3 = null;
            this.setRootPaneCheckingEnabled(bl2);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setRootPaneCheckingEnabled(bl2);
            throw throwable;
        }
    }

    public void updateUI() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        if (this.desktopIcon != null) {
            this.desktopIcon.updateUIWhenHidden();
        }
    }

    void updateUIWhenHidden() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                SwingUtilities.updateComponentTreeUI(componentArray[n2]);
                ++n2;
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl2) {
        this.rootPaneCheckingEnabled = bl2;
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n2);
    }

    public void remove(Component component) {
        int n2 = this.getComponentCount();
        super.remove(component);
        if (n2 == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    public JMenuBar getMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl2 = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var5_4 = null;
                this.setRootPaneCheckingEnabled(bl2);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setRootPaneCheckingEnabled(bl2);
                throw throwable;
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, jRootPane);
    }

    public void setClosable(boolean bl2) {
        Boolean bl3 = this.closable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.closable = bl2;
        this.firePropertyChange("closable", bl3, bl4);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl2) throws PropertyVetoException {
        Boolean bl3;
        if (this.isClosed == bl2) {
            return;
        }
        Boolean bl4 = this.isClosed ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl5 = bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        if (bl2) {
            this.fireInternalFrameEvent(25550);
        }
        this.fireVetoableChange(IS_CLOSED_PROPERTY, bl4, bl3);
        this.isClosed = bl2;
        this.firePropertyChange(IS_CLOSED_PROPERTY, bl4, bl3);
        if (this.isClosed) {
            this.dispose();
        } else if (!this.opened) {
            // empty if block
        }
    }

    public void setResizable(boolean bl2) {
        Boolean bl3 = this.resizable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.resizable = bl2;
        this.firePropertyChange("resizable", bl3, bl4);
    }

    public boolean isResizable() {
        return this.isMaximum ? false : this.resizable;
    }

    public void setIconifiable(boolean bl2) {
        Boolean bl3 = this.iconable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.iconable = bl2;
        this.firePropertyChange("iconable", bl3, bl4);
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public void setIcon(boolean bl2) throws PropertyVetoException {
        if (this.isIcon == bl2) {
            return;
        }
        this.firePropertyChange("ancestor", null, this.getParent());
        Boolean bl3 = this.isIcon ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_ICON_PROPERTY, bl3, bl4);
        this.isIcon = bl2;
        this.firePropertyChange(IS_ICON_PROPERTY, bl3, bl4);
        if (bl2) {
            this.fireInternalFrameEvent(25552);
        } else {
            this.fireInternalFrameEvent(25553);
        }
    }

    public void setMaximizable(boolean bl2) {
        Boolean bl3 = this.maximizable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.maximizable = bl2;
        this.firePropertyChange("maximizable", bl3, bl4);
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public void setMaximum(boolean bl2) throws PropertyVetoException {
        if (this.isMaximum == bl2) {
            return;
        }
        Boolean bl3 = this.isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_MAXIMUM_PROPERTY, bl3, bl4);
        this.isMaximum = bl2;
        this.firePropertyChange(IS_MAXIMUM_PROPERTY, bl3, bl4);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, string);
    }

    public void setSelected(boolean bl2) throws PropertyVetoException {
        if (this.isSelected == bl2 || bl2 && (this.isIcon ? !this.desktopIcon.isShowing() : !this.isShowing())) {
            return;
        }
        Boolean bl3 = this.isSelected ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_SELECTED_PROPERTY, bl3, bl4);
        this.lastFocusOwner = null;
        if (bl2) {
            this.restoreSubcomponentFocus();
        } else {
            this.getRootPane().setMostRecentFocusOwner(this.getFocusOwner());
        }
        this.isSelected = bl2;
        this.firePropertyChange(IS_SELECTED_PROPERTY, bl3, bl4);
        if (this.isSelected) {
            this.fireInternalFrameEvent(25554);
        } else {
            this.fireInternalFrameEvent(25555);
        }
        this.lastFocusOwner = null;
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setFrameIcon(Icon icon) {
        Icon icon2 = this.frameIcon;
        this.frameIcon = icon;
        this.firePropertyChange(FRAME_ICON_PROPERTY, icon2, icon);
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public void moveToFront() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            Component component;
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            Component component2 = component = this.lastFocusOwner != null ? this.lastFocusOwner : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != null && !SwingUtilities.isDescendingFrom(component, this)) {
                component = null;
            }
            jLayeredPane.moveToFront(this);
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    public void moveToBack() {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.moveToBack(this);
        }
    }

    public void setLayer(Integer n2) {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.setLayer(this, n2, jLayeredPane.getPosition(this));
        } else {
            JLayeredPane.putLayer(this, n2);
            if (this.getParent() != null) {
                this.getParent().repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
            }
        }
    }

    public void setLayer(int n2) {
        this.setLayer(new Integer(n2));
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JDesktopPane getDesktopPane() {
        Container container = this.getParent();
        while (container != null && !(container instanceof JDesktopPane)) {
            container = container.getParent();
        }
        if (container == null) {
            container = this.getDesktopIcon().getParent();
            while (container != null && !(container instanceof JDesktopPane)) {
                container = container.getParent();
            }
        }
        return (JDesktopPane)container;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        JDesktopIcon jDesktopIcon2 = this.getDesktopIcon();
        this.desktopIcon = jDesktopIcon;
        this.firePropertyChange("desktopIcon", jDesktopIcon2, jDesktopIcon);
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    public Rectangle getNormalBounds() {
        if (this.normalBounds != null) {
            return this.normalBounds;
        }
        return this.getBounds();
    }

    public void setNormalBounds(Rectangle rectangle) {
        this.normalBounds = rectangle;
    }

    public Component getFocusOwner() {
        if (this.isSelected()) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != null && !SwingUtilities.isDescendingFrom(component, this)) {
                component = null;
            }
            return component;
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        Component component = this.getRootPane().getMostRecentFocusOwner();
        if (component != null) {
            return component;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof InternalFrameFocusTraversalPolicy) {
            return ((InternalFrameFocusTraversalPolicy)focusTraversalPolicy).getInitialComponent(this);
        }
        return focusTraversalPolicy.getDefaultComponent(this);
    }

    public void restoreSubcomponentFocus() {
        this.lastFocusOwner = this.getMostRecentFocusOwner();
        if (this.lastFocusOwner == null) {
            this.lastFocusOwner = this.getContentPane();
        }
        this.lastFocusOwner.requestFocus();
    }

    /*
     * Unable to fully structure code
     */
    synchronized void startModal() {
        block10: {
            if (this.isVisible() && !this.isShowing()) {
                var1_1 = this.getParent();
                while (var1_1 != null) {
                    if (!var1_1.isVisible()) {
                        var1_1.setVisible(true);
                    }
                    var1_1 = var1_1.getParent();
                }
            }
            try {
                if (!SwingUtilities.isEventDispatchThread()) ** GOTO lbl27
                var1_1 = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    var2_3 = var1_1.getNextEvent();
                    var3_4 = var2_3.getSource();
                    if (var2_3 instanceof ActiveEvent) {
                        ((ActiveEvent)var2_3).dispatch();
                        continue;
                    }
                    if (var3_4 instanceof Component) {
                        ((Component)var3_4).dispatchEvent(var2_3);
                        continue;
                    }
                    if (var3_4 instanceof MenuComponent) {
                        ((MenuComponent)var3_4).dispatchEvent(var2_3);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + var2_3);
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    this.wait();
lbl27:
                    // 2 sources

                    ** while (this.isVisible())
                }
lbl28:
                // 1 sources

            }
            catch (InterruptedException var1_2) {}
        }
    }

    synchronized void stopModal() {
        this.notifyAll();
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        this.validate();
        this.repaint();
    }

    public void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.add(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = JInternalFrame.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener, internalFrameListener);
        this.enableEvents(0L);
    }

    public void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.remove(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = JInternalFrame.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener, internalFrameListener);
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(class$javax$swing$event$InternalFrameListener == null ? (class$javax$swing$event$InternalFrameListener = JInternalFrame.class$("javax.swing.event.InternalFrameListener")) : class$javax$swing$event$InternalFrameListener);
    }

    protected void fireInternalFrameEvent(int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$javax$swing$event$InternalFrameListener == null ? JInternalFrame.class$("javax.swing.event.InternalFrameListener") : class$javax$swing$event$InternalFrameListener)) {
                if (aWTEvent == null) {
                    aWTEvent = new InternalFrameEvent(this, n2);
                }
                switch (aWTEvent.getID()) {
                    case 25549: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameOpened((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25550: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameClosing((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25551: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameClosed((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25552: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameIconified((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25553: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameDeiconified((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25554: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameActivated((InternalFrameEvent)aWTEvent);
                        break;
                    }
                    case 25555: {
                        ((InternalFrameListener)objectArray[n3 + 1]).internalFrameDeactivated((InternalFrameEvent)aWTEvent);
                        break;
                    }
                }
            }
            n3 -= 2;
        }
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.defaultCloseOperation) {
            case 0: {
                break;
            }
            case 1: {
                this.setVisible(false);
                if (!this.isSelected()) break;
                try {
                    this.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                try {
                    this.fireVetoableChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.isClosed = true;
                    this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.dispose();
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
    }

    public void setDefaultCloseOperation(int n2) {
        this.defaultCloseOperation = n2;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        block5: {
            if (this.isVisible()) {
                return;
            }
            if (!this.opened) {
                this.fireInternalFrameEvent(25549);
                this.opened = true;
            }
            this.getDesktopIcon().setVisible(true);
            this.toFront();
            super.show();
            if (this.isIcon) {
                return;
            }
            if (this.isSelected()) break block5;
            try {
                this.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void hide() {
        if (this.isIcon()) {
            this.getDesktopIcon().setVisible(false);
        }
        super.hide();
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!this.isClosed) {
            this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            this.isClosed = true;
        }
        this.fireInternalFrameEvent(25551);
    }

    public void toFront() {
        this.moveToFront();
    }

    public void toBack() {
        this.moveToBack();
    }

    public final void setFocusCycleRoot(boolean bl2) {
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final String getWarningString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                boolean bl2 = this.isRootPaneCheckingEnabled();
                try {
                    this.setRootPaneCheckingEnabled(false);
                    this.ui.installUI(this);
                    Object var5_4 = null;
                    this.setRootPaneCheckingEnabled(bl2);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.setRootPaneCheckingEnabled(bl2);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compWriteObjectNotify() {
        boolean bl2 = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.compWriteObjectNotify();
            Object var3_2 = null;
            this.setRootPaneCheckingEnabled(bl2);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setRootPaneCheckingEnabled(bl2);
            throw throwable;
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        String string4 = this.closable ? "true" : "false";
        String string5 = this.isClosed ? "true" : "false";
        String string6 = this.maximizable ? "true" : "false";
        String string7 = this.isMaximum ? "true" : "false";
        String string8 = this.iconable ? "true" : "false";
        String string9 = this.isIcon ? "true" : "false";
        String string10 = this.resizable ? "true" : "false";
        String string11 = this.isSelected ? "true" : "false";
        String string12 = this.frameIcon != null ? this.frameIcon.toString() : "";
        String string13 = this.title != null ? this.title : "";
        String string14 = this.desktopIcon != null ? this.desktopIcon.toString() : "";
        String string15 = string = this.opened ? "true" : "false";
        String string16 = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        return super.paramString() + ",closable=" + string4 + ",defaultCloseOperation=" + string16 + ",desktopIcon=" + string14 + ",frameIcon=" + string12 + ",iconable=" + string8 + ",isClosed=" + string5 + ",isIcon=" + string9 + ",isMaximum=" + string7 + ",isSelected=" + string11 + ",maximizable=" + string6 + ",opened=" + string + ",resizable=" + string10 + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3 + ",title=" + string13;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isDragging) {
            this.danger = true;
        }
        super.paintComponent(graphics);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        JInternalFrame internalFrame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.setVisible(false);
            this.setInternalFrame(jInternalFrame);
            this.updateUI();
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.internalFrame = jInternalFrame;
        }

        public JDesktopPane getDesktopPane() {
            if (this.getInternalFrame() != null) {
                return this.getInternalFrame().getDesktopPane();
            }
            return null;
        }

        public void updateUI() {
            boolean bl2 = this.ui != null;
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            if (this.internalFrame != null && this.internalFrame.getUI() != null) {
                SwingUtilities.updateComponentTreeUI(this.internalFrame);
            }
        }

        void updateUIWhenHidden() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            this.invalidate();
            Component[] componentArray = this.getComponents();
            if (componentArray != null) {
                int n2 = 0;
                while (n2 < componentArray.length) {
                    SwingUtilities.updateComponentTreeUI(componentArray[n2]);
                    ++n2;
                }
            }
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.getUIClassID().equals("DesktopIconUI")) {
                byte by = JComponent.getWriteObjCounter(this);
                by = (byte)(by - 1);
                JComponent.setWriteObjCounter(this, by);
                if (by == 0 && this.ui != null) {
                    this.ui.installUI(this);
                }
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon();
            }
            return this.accessibleContext;
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            protected AccessibleJDesktopIcon() {
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.getCurrentAccessibleValue();
                }
                return null;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.setCurrentAccessibleValue(number);
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMinimumAccessibleValue();
                }
                return null;
            }

            public Number getMaximumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMaximumAccessibleValue();
                }
                return null;
            }
        }
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJInternalFrame() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return JInternalFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JInternalFrame.this.getLayer());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                JInternalFrame.this.setLayer((Integer)number);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }
    }
}

