/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;

public final class ImageIO {
    private static final IIORegistry theRegistry = IIORegistry.getDefaultInstance();
    private static Method readerFormatNamesMethod;
    private static Method readerFileSuffixesMethod;
    private static Method readerMIMETypesMethod;
    private static Method writerFormatNamesMethod;
    private static Method writerFileSuffixesMethod;
    private static Method writerMIMETypesMethod;
    static /* synthetic */ Class class$javax$imageio$ImageIO$CacheInfo;
    static /* synthetic */ Class class$javax$imageio$spi$ImageInputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageOutputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageTranscoderSpi;

    private ImageIO() {
    }

    public static void scanForPlugins() {
        theRegistry.registerApplicationClasspathSpis();
    }

    private static synchronized CacheInfo getCacheInfo() {
        AppContext appContext = AppContext.getAppContext();
        CacheInfo cacheInfo = (CacheInfo)appContext.get(class$javax$imageio$ImageIO$CacheInfo == null ? (class$javax$imageio$ImageIO$CacheInfo = ImageIO.class$("javax.imageio.ImageIO$CacheInfo")) : class$javax$imageio$ImageIO$CacheInfo);
        if (cacheInfo == null) {
            cacheInfo = new CacheInfo();
            appContext.put(class$javax$imageio$ImageIO$CacheInfo == null ? (class$javax$imageio$ImageIO$CacheInfo = ImageIO.class$("javax.imageio.ImageIO$CacheInfo")) : class$javax$imageio$ImageIO$CacheInfo, cacheInfo);
        }
        return cacheInfo;
    }

    private static String getTempDir() {
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
        return (String)AccessController.doPrivileged(getPropertyAction);
    }

    private static boolean hasCachePermission() {
        Boolean bl2 = ImageIO.getCacheInfo().getHasPermission();
        if (bl2 != null) {
            return bl2;
        }
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                String string;
                File file = ImageIO.getCacheDirectory();
                if (file != null) {
                    string = file.getPath();
                } else {
                    string = ImageIO.getTempDir();
                    if (string == null) {
                        ImageIO.getCacheInfo().setHasPermission(Boolean.FALSE);
                        return false;
                    }
                }
                securityManager.checkWrite(string);
            }
        }
        catch (SecurityException securityException) {
            ImageIO.getCacheInfo().setHasPermission(Boolean.FALSE);
            return false;
        }
        ImageIO.getCacheInfo().setHasPermission(Boolean.TRUE);
        return true;
    }

    public static void setUseCache(boolean bl2) {
        ImageIO.getCacheInfo().setUseCache(bl2);
    }

    public static boolean getUseCache() {
        return ImageIO.getCacheInfo().getUseCache();
    }

    public static void setCacheDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Not a directory!");
        }
        ImageIO.getCacheInfo().setCacheDirectory(file);
        ImageIO.getCacheInfo().setHasPermission(null);
    }

    public static File getCacheDirectory() {
        return ImageIO.getCacheInfo().getCacheDirectory();
    }

    public static ImageInputStream createImageInputStream(Object object) throws IOException {
        Iterator iterator;
        if (object == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageInputStreamSpi == null ? (class$javax$imageio$spi$ImageInputStreamSpi = ImageIO.class$("javax.imageio.spi.ImageInputStreamSpi")) : class$javax$imageio$spi$ImageInputStreamSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        boolean bl2 = ImageIO.getUseCache() && ImageIO.hasCachePermission();
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi = (ImageInputStreamSpi)iterator.next();
            if (!imageInputStreamSpi.getInputClass().isInstance(object)) continue;
            try {
                return imageInputStreamSpi.createInputStreamInstance(object, bl2, ImageIO.getCacheDirectory());
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    public static ImageOutputStream createImageOutputStream(Object object) throws IOException {
        Iterator iterator;
        if (object == null) {
            throw new IllegalArgumentException("output == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageOutputStreamSpi == null ? (class$javax$imageio$spi$ImageOutputStreamSpi = ImageIO.class$("javax.imageio.spi.ImageOutputStreamSpi")) : class$javax$imageio$spi$ImageOutputStreamSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        boolean bl2 = ImageIO.getUseCache() && ImageIO.hasCachePermission();
        while (iterator.hasNext()) {
            ImageOutputStreamSpi imageOutputStreamSpi = (ImageOutputStreamSpi)iterator.next();
            if (!imageOutputStreamSpi.getOutputClass().isInstance(object)) continue;
            try {
                return imageOutputStreamSpi.createOutputStreamInstance(object, bl2, ImageIO.getCacheDirectory());
            }
            catch (IOException iOException) {
                throw new IIOException("Can't create cache file!", iOException);
            }
        }
        return null;
    }

    private static String[] toStringArray(Set set) {
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = (String)iterator.next();
        }
        return stringArray;
    }

    public static String[] getReaderFormatNames() {
        Iterator iterator;
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
            String[] stringArray = imageReaderSpi.getFormatNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashSet.add(stringArray[n2]);
                ++n2;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static String[] getReaderMIMETypes() {
        Iterator iterator;
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
            String[] stringArray = imageReaderSpi.getMIMETypes();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashSet.add(stringArray[n2]);
                ++n2;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static Iterator getImageReaders(Object object) {
        Iterator iterator;
        if (object == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new CanDecodeInputFilter(object), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersByFormatName(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerFormatNamesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersBySuffix(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerFileSuffixesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static Iterator getImageReadersByMIMEType(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("MIMEType == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, new ContainsFilter(readerMIMETypesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageReaderIterator(iterator);
    }

    public static String[] getWriterFormatNames() {
        Iterator iterator;
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            String[] stringArray = imageWriterSpi.getFormatNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashSet.add(stringArray[n2]);
                ++n2;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    public static String[] getWriterMIMETypes() {
        Iterator iterator;
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            String[] stringArray = imageWriterSpi.getMIMETypes();
            int n2 = 0;
            while (n2 < stringArray.length) {
                hashSet.add(stringArray[n2]);
                ++n2;
            }
        }
        return ImageIO.toStringArray(hashSet);
    }

    private static boolean contains(String[] stringArray, String string) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Iterator getImageWritersByFormatName(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerFormatNamesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageWritersBySuffix(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerFileSuffixesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageWritersByMIMEType(String string) {
        Iterator iterator;
        if (string == null) {
            throw new IllegalArgumentException("MIMEType == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ContainsFilter(writerMIMETypesMethod, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    /*
     * Unable to fully structure code
     */
    public static ImageWriter getImageWriter(ImageReader var0) {
        block11: {
            if (var0 == null) {
                throw new IllegalArgumentException("reader == null!");
            }
            var1_1 = var0.getOriginatingProvider();
            if (var1_1 != null) break block11;
            try {
                var2_2 = ImageIO.theRegistry.getServiceProviders(ImageIO.class$javax$imageio$spi$ImageReaderSpi == null ? (ImageIO.class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : ImageIO.class$javax$imageio$spi$ImageReaderSpi, false);
                if (true) ** GOTO lbl14
            }
            catch (IllegalArgumentException var3_3) {
                return null;
            }
            do {
                if (!(var3_4 = (ImageReaderSpi)var2_2.next()).isOwnReader(var0)) continue;
                var1_1 = var3_4;
                break;
lbl14:
                // 2 sources

            } while (var2_2.hasNext());
            if (var1_1 == null) {
                return null;
            }
        }
        if ((var2_2 = var1_1.getImageWriterSpiNames()) == null) {
            return null;
        }
        var3_4 = null;
        try {
            var3_4 = Class.forName((String)var2_2[0], true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException var4_5) {
            return null;
        }
        var4_6 = (ImageWriterSpi)ImageIO.theRegistry.getServiceProviderByClass((Class)var3_4);
        if (var4_6 == null) {
            return null;
        }
        try {
            return var4_6.createWriterInstance();
        }
        catch (IOException var5_7) {
            ImageIO.theRegistry.deregisterServiceProvider(var4_6, ImageIO.class$javax$imageio$spi$ImageWriterSpi == null ? (ImageIO.class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : ImageIO.class$javax$imageio$spi$ImageWriterSpi);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ImageReader getImageReader(ImageWriter var0) {
        block11: {
            if (var0 == null) {
                throw new IllegalArgumentException("writer == null!");
            }
            var1_1 = var0.getOriginatingProvider();
            if (var1_1 != null) break block11;
            try {
                var2_2 = ImageIO.theRegistry.getServiceProviders(ImageIO.class$javax$imageio$spi$ImageWriterSpi == null ? (ImageIO.class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : ImageIO.class$javax$imageio$spi$ImageWriterSpi, false);
                if (true) ** GOTO lbl14
            }
            catch (IllegalArgumentException var3_3) {
                return null;
            }
            do {
                if (!(var3_4 = (ImageWriterSpi)var2_2.next()).isOwnWriter(var0)) continue;
                var1_1 = var3_4;
                break;
lbl14:
                // 2 sources

            } while (var2_2.hasNext());
            if (var1_1 == null) {
                return null;
            }
        }
        if ((var2_2 = var1_1.getImageReaderSpiNames()) == null) {
            return null;
        }
        var3_4 = null;
        try {
            var3_4 = Class.forName((String)var2_2[0], true, ClassLoader.getSystemClassLoader());
        }
        catch (ClassNotFoundException var4_5) {
            return null;
        }
        var4_6 = (ImageReaderSpi)ImageIO.theRegistry.getServiceProviderByClass((Class)var3_4);
        if (var4_6 == null) {
            return null;
        }
        try {
            return var4_6.createReaderInstance();
        }
        catch (IOException var5_7) {
            ImageIO.theRegistry.deregisterServiceProvider(var4_6, ImageIO.class$javax$imageio$spi$ImageReaderSpi == null ? (ImageIO.class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : ImageIO.class$javax$imageio$spi$ImageReaderSpi);
            return null;
        }
    }

    public static Iterator getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        Iterator iterator;
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("type == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new CanEncodeImageAndFormatFilter(imageTypeSpecifier, string), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageWriterIterator(iterator);
    }

    public static Iterator getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        Iterator iterator;
        if (imageReader == null) {
            throw new IllegalArgumentException("reader == null!");
        }
        if (imageWriter == null) {
            throw new IllegalArgumentException("writer == null!");
        }
        ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        TranscoderFilter transcoderFilter = new TranscoderFilter(imageReaderSpi, imageWriterSpi);
        try {
            iterator = theRegistry.getServiceProviders(class$javax$imageio$spi$ImageTranscoderSpi == null ? (class$javax$imageio$spi$ImageTranscoderSpi = ImageIO.class$("javax.imageio.spi.ImageTranscoderSpi")) : class$javax$imageio$spi$ImageTranscoderSpi, transcoderFilter, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new HashSet().iterator();
        }
        return new ImageTranscoderIterator(iterator);
    }

    public static BufferedImage read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!file.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        return ImageIO.read(imageInputStream);
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        return ImageIO.read(imageInputStream);
    }

    public static BufferedImage read(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("input == null!");
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IIOException("Can't get input stream from URL!", iOException);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        inputStream.close();
        return bufferedImage;
    }

    public static BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        Iterator iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = (ImageReader)iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, true);
        BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
        imageInputStream.close();
        imageReader.dispose();
        return bufferedImage;
    }

    public static boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IOException {
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (imageOutputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageWriter imageWriter = null;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
        Iterator iterator = ImageIO.getImageWriters(imageTypeSpecifier, string);
        if (iterator.hasNext()) {
            imageWriter = (ImageWriter)iterator.next();
        }
        if (imageWriter == null) {
            return false;
        }
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(renderedImage);
        imageOutputStream.flush();
        imageWriter.dispose();
        return true;
    }

    public static boolean write(RenderedImage renderedImage, String string, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream imageOutputStream = null;
        try {
            file.delete();
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        boolean bl2 = ImageIO.write(renderedImage, string, imageOutputStream);
        imageOutputStream.close();
        return bl2;
    }

    public static boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IIOException("Can't create output stream!", iOException);
        }
        boolean bl2 = ImageIO.write(renderedImage, string, imageOutputStream);
        imageOutputStream.close();
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            readerFormatNamesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getFormatNames", null);
            readerFileSuffixesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getFileSuffixes", null);
            readerMIMETypesMethod = (class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi).getMethod("getMIMETypes", null);
            writerFormatNamesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getFormatNames", null);
            writerFileSuffixesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getFileSuffixes", null);
            writerMIMETypesMethod = (class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi).getMethod("getMIMETypes", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    static class TranscoderFilter
    implements ServiceRegistry.Filter {
        String readerSpiName;
        String writerSpiName;

        public TranscoderFilter(ImageReaderSpi imageReaderSpi, ImageWriterSpi imageWriterSpi) {
            this.readerSpiName = imageReaderSpi.getClass().getName();
            this.writerSpiName = imageWriterSpi.getClass().getName();
        }

        public boolean filter(Object object) {
            ImageTranscoderSpi imageTranscoderSpi = (ImageTranscoderSpi)object;
            String string = imageTranscoderSpi.getReaderServiceProviderName();
            String string2 = imageTranscoderSpi.getWriterServiceProviderName();
            return string.equals(this.readerSpiName) && string2.equals(this.writerSpiName);
        }
    }

    static class ImageTranscoderIterator
    implements Iterator {
        public Iterator iter;

        public ImageTranscoderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageTranscoderSpi imageTranscoderSpi = null;
            imageTranscoderSpi = (ImageTranscoderSpi)this.iter.next();
            return imageTranscoderSpi.createTranscoderInstance();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ImageWriterIterator
    implements Iterator {
        public Iterator iter;

        public ImageWriterIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageWriterSpi imageWriterSpi = null;
            try {
                imageWriterSpi = (ImageWriterSpi)this.iter.next();
                return imageWriterSpi.createWriterInstance();
            }
            catch (IOException iOException) {
                theRegistry.deregisterServiceProvider(imageWriterSpi, class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = ImageIO.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class ContainsFilter
    implements ServiceRegistry.Filter {
        Method method;
        String name;

        public ContainsFilter(Method method, String string) {
            this.method = method;
            this.name = string;
        }

        public boolean filter(Object object) {
            try {
                return ImageIO.contains((String[])this.method.invoke(object, null), this.name);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    static class CanEncodeImageAndFormatFilter
    implements ServiceRegistry.Filter {
        ImageTypeSpecifier type;
        String formatName;

        public CanEncodeImageAndFormatFilter(ImageTypeSpecifier imageTypeSpecifier, String string) {
            this.type = imageTypeSpecifier;
            this.formatName = string;
        }

        public boolean filter(Object object) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
            return Arrays.asList(imageWriterSpi.getFormatNames()).contains(this.formatName) && imageWriterSpi.canEncodeImage(this.type);
        }
    }

    static class CanDecodeInputFilter
    implements ServiceRegistry.Filter {
        Object input;

        public CanDecodeInputFilter(Object object) {
            this.input = object;
        }

        public boolean filter(Object object) {
            try {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                ImageInputStream imageInputStream = null;
                if (this.input instanceof ImageInputStream) {
                    imageInputStream = (ImageInputStream)this.input;
                }
                boolean bl2 = false;
                if (imageInputStream != null) {
                    imageInputStream.mark();
                }
                bl2 = imageReaderSpi.canDecodeInput(this.input);
                if (imageInputStream != null) {
                    imageInputStream.reset();
                }
                return bl2;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    static class ImageReaderIterator
    implements Iterator {
        public Iterator iter;

        public ImageReaderIterator(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            ImageReaderSpi imageReaderSpi = null;
            try {
                imageReaderSpi = (ImageReaderSpi)this.iter.next();
                return imageReaderSpi.createReaderInstance();
            }
            catch (IOException iOException) {
                theRegistry.deregisterServiceProvider(imageReaderSpi, class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = ImageIO.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi);
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class CacheInfo {
        boolean useCache = true;
        File cacheDirectory = null;
        Boolean hasPermission = null;

        public boolean getUseCache() {
            return this.useCache;
        }

        public void setUseCache(boolean bl2) {
            this.useCache = bl2;
        }

        public File getCacheDirectory() {
            return this.cacheDirectory;
        }

        public void setCacheDirectory(File file) {
            this.cacheDirectory = file;
        }

        public Boolean getHasPermission() {
            return this.hasPermission;
        }

        public void setHasPermission(Boolean bl2) {
            this.hasPermission = bl2;
        }
    }
}

