/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.X500Name;

public class TrustAnchor {
    private PublicKey pubKey;
    private String caName;
    private X509Certificate trustedCert;
    private byte[] ncBytes;
    private NameConstraintsExtension nc;
    private static final Boolean falseBoolean = new Boolean(false);

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) {
        if (x509Certificate == null) {
            throw new NullPointerException("the trustedCert parameter must be non-null");
        }
        this.trustedCert = x509Certificate;
        this.pubKey = null;
        this.caName = null;
        this.setNameConstraints(byArray);
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) {
        if (publicKey == null) {
            throw new NullPointerException("the pubKey parameter must be non-null");
        }
        if (string == null) {
            throw new NullPointerException("the caName parameter must be non-null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("the caName parameter must be a non-empty String");
        }
        try {
            new X500Name(string, "RFC2253");
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        this.pubKey = publicKey;
        this.caName = string;
        this.trustedCert = null;
        this.setNameConstraints(byArray);
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final String getCAName() {
        return this.caName;
    }

    public final PublicKey getCAPublicKey() {
        return this.pubKey;
    }

    private void setNameConstraints(byte[] byArray) {
        if (byArray == null) {
            this.ncBytes = null;
            this.nc = null;
        } else {
            this.ncBytes = (byte[])byArray.clone();
            try {
                this.nc = new NameConstraintsExtension(falseBoolean, byArray);
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
    }

    public final byte[] getNameConstraints() {
        return this.ncBytes == null ? null : (byte[])this.ncBytes.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        if (this.pubKey != null) {
            stringBuffer.append("  Trusted CA Public Key: " + this.pubKey.toString() + "\n");
            stringBuffer.append("  Trusted CA Issuer Name: " + String.valueOf(this.caName) + "\n");
        } else {
            stringBuffer.append("  Trusted CA cert: " + this.trustedCert.toString() + "\n");
        }
        if (this.nc != null) {
            stringBuffer.append("  Name Constraints: " + this.nc.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

