/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.reflect.Reflection;

public abstract class ClassLoader {
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private Vector classes = new Vector();
    private Set domains = new HashSet();
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private static RuntimePermission getClassLoaderPerm;
    private ProtectionDomain defaultDomain = null;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map packageAssertionStatus = null;
    Map classAssertionStatus = null;

    private static native void registerNatives();

    void addClass(Class clazz) {
        this.classes.addElement(clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = ClassLoader.getSystemClassLoader();
        this.initialized = true;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl2) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
            }
        }
        if (bl2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n2;
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n2 = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string.substring(0, n2));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n2, int n3) throws ClassFormatError {
        return this.defineClass(null, byArray, n2, n3, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n2, int n3) throws ClassFormatError {
        return this.defineClass(string, byArray, n2, n3, null);
    }

    /*
     * Unable to fully structure code
     */
    protected final Class defineClass(String var1_1, byte[] var2_2, int var3_3, int var4_4, ProtectionDomain var5_5) throws ClassFormatError {
        block10: {
            this.check();
            if (var1_1 != null && var1_1.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + var1_1.substring(0, var1_1.lastIndexOf(46)));
            }
            if (var5_5 == null) {
                var5_5 = this.getDefaultDomain();
            }
            if (var1_1 != null) {
                this.checkCerts(var1_1, var5_5.getCodeSource());
            }
            var6_6 = null;
            try {
                var6_6 = this.defineClass0(var1_1, var2_2, var3_3, var4_4, var5_5);
                break block10;
            }
            catch (ClassFormatError var7_7) {
                var8_9 = ClassFileTransformer.getTransformers();
                var9_10 = 0;
                ** while (var8_9 != null && var9_10 < var8_9.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var10_12 = ((ClassFileTransformer)var8_9[var9_10]).transform(var2_2, var3_3, var4_4);
                    var6_6 = this.defineClass0(var1_1, var10_12, 0, var10_12.length, var5_5);
                    break;
                }
                catch (ClassFormatError var10_11) {
                    ++var9_10;
                }
                continue;
            }
lbl23:
            // 2 sources

            if (var6_6 == null) {
                throw var7_7;
            }
        }
        if (var5_5.getCodeSource() != null && (var7_8 = var5_5.getCodeSource().getCertificates()) != null) {
            this.setSigners(var6_6, var7_8);
        }
        return var6_6;
    }

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n2 = string.lastIndexOf(46);
        String string2 = n2 == -1 ? "" : string.substring(0, n2);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n2;
        boolean bl2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < certificateArray2.length) {
            bl2 = false;
            n2 = 0;
            while (n2 < certificateArray.length) {
                if (certificateArray2[n3].equals(certificateArray[n2])) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return false;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < certificateArray.length) {
            bl2 = false;
            int n4 = 0;
            while (n4 < certificateArray2.length) {
                if (certificateArray[n2].equals(certificateArray2[n4])) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        return this.findBootstrapClass(string);
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private native void resolveClass0(Class var1);

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final native Class findLoadedClass(String var1);

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    protected URL findResource(String string) {
        return null;
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(ClassLoader.getGetClassLoaderPerm());
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive call");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        SystemClassLoaderAction systemClassLoaderAction = new SystemClassLoaderAction(scl);
                        scl = (ClassLoader)AccessController.doPrivileged(systemClassLoaderAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static ClassLoader getCallerClassLoader() {
        Class clazz = Reflection.getCallerClass(3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader0();
    }

    static RuntimePermission getGetClassLoaderPerm() {
        if (getClassLoaderPerm == null) {
            getClassLoaderPerm = new RuntimePermission("getClassLoader");
        }
        return getClassLoaderPerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Map map;
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            map = (Map)this.packages.clone();
        }
        Package[] packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
        if (packageArray != null) {
            int n2 = 0;
            while (n2 < packageArray.length) {
                String string = packageArray[n2].getName();
                if (map.get(string) == null) {
                    map.put(string, packageArray[n2]);
                }
                ++n2;
            }
        }
        return (Package[])map.values().toArray(new Package[map.size()]);
    }

    protected String findLibrary(String string) {
        return null;
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n2 = string2.length();
        int n3 = string2.indexOf(string3);
        int n4 = 0;
        while (n3 >= 0) {
            ++n4;
            n3 = string2.indexOf(string3, n3 + 1);
        }
        String[] stringArray = new String[n4 + 1];
        n3 = 0;
        n4 = 0;
        int n5 = string2.indexOf(string3);
        while (n5 >= 0) {
            if (n5 - n3 > 0) {
                stringArray[n4++] = string2.substring(n3, n5);
            } else if (n5 - n3 == 0) {
                stringArray[n4++] = ".";
            }
            n3 = n5 + 1;
            n5 = string2.indexOf(string3, n3);
        }
        stringArray[n4] = string2.substring(n3, n2);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl2) {
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl2) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file = new File(string2);
            if (!file.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        int n2 = 0;
        while (n2 < sys_paths.length) {
            File file = new File(sys_paths[n2], System.mapLibraryName(string));
            if (ClassLoader.loadLibrary0(clazz, file)) {
                return;
            }
            ++n2;
        }
        if (classLoader != null) {
            int n3 = 0;
            while (n3 < usr_paths.length) {
                File file = new File(usr_paths[n3], System.mapLibraryName(string));
                if (ClassLoader.loadLibrary0(clazz, file)) {
                    return;
                }
                ++n3;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary0(Class clazz, final File file) {
        Vector vector;
        String string;
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (!bl2.booleanValue()) {
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            Object object;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                object = (NativeLibrary)vector.elementAt(n3);
                if (string.equals(((NativeLibrary)object).name)) {
                    return true;
                }
                ++n3;
            }
            object = loadedLibraryNames;
            synchronized (object) {
                NativeLibrary nativeLibrary;
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n4 = nativeLibraryContext.size();
                int n5 = 0;
                while (n5 < n4) {
                    nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(n5);
                    if (string.equals(nativeLibrary.name)) {
                        if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                            return true;
                        }
                        throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                    }
                    ++n5;
                }
                nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string);
                    Object var14_14 = null;
                    nativeLibraryContext.pop();
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    nativeLibraryContext.pop();
                    throw throwable;
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(n3);
                long l2 = nativeLibrary.find(string);
                if (l2 != 0L) {
                    return l2;
                }
                ++n3;
            }
        }
        return 0L;
    }

    public synchronized void setDefaultAssertionStatus(boolean bl2) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl2;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl2) {
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl2);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl2) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl2);
    }

    public synchronized void clearAssertionStatus() {
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        this.defaultAssertionStatus = false;
    }

    /*
     * Unable to fully structure code
     */
    synchronized boolean desiredAssertionStatus(String var1_1) {
        var2_2 = (Boolean)this.classAssertionStatus.get(var1_1);
        if (var2_2 != null) {
            return var2_2;
        }
        var3_3 = var1_1.lastIndexOf(".");
        if (var3_3 >= 0 || (var2_2 = (Boolean)this.packageAssertionStatus.get(null)) == null) ** GOTO lbl11
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var2_2 = (Boolean)this.packageAssertionStatus.get(var1_1 = var1_1.substring(0, var3_3));
            if (var2_2 != null) {
                return var2_2;
            }
            var3_3 = var1_1.lastIndexOf(".", var3_3 - 1);
lbl11:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl12:
        // 1 sources

        return this.defaultAssertionStatus;
    }

    private void initializeJavaAssertionMaps() {
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        int n2 = 0;
        while (n2 < assertionStatusDirectives.classes.length) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n2], assertionStatusDirectives.classEnabled[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < assertionStatusDirectives.packages.length) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n3], assertionStatusDirectives.packageEnabled[n3]);
            ++n3;
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        ClassLoader.registerNatives();
        getClassLoaderPerm = null;
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n2 = loadedLibraryNames.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (this.name.equals(loadedLibraryNames.elementAt(n3))) {
                            loadedLibraryNames.removeElementAt(n3);
                            break;
                        }
                        ++n3;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                        Object var5_4 = null;
                        nativeLibraryContext.pop();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        nativeLibraryContext.pop();
                        throw throwable;
                    }
                    {
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }
}

