/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTPermission;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.event.AWTEventListenerProxy;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.awt.DebugHelper;
import sun.awt.HeadlessToolkit;
import sun.awt.NullComponentPeer;
import sun.security.action.LoadLibraryAction;

public abstract class Toolkit {
    private static LightweightPeer lightweightMarker;
    private static Toolkit toolkit;
    private static ResourceBundle resources;
    private static boolean loaded;
    protected final Map desktopProperties = new HashMap();
    protected final PropertyChangeSupport desktopPropsSupport = new PropertyChangeSupport(this);
    private static final DebugHelper dbg;
    private static final int LONG_BITS = 64;
    private int[] calls = new int[64];
    private AWTEventListener eventListener = null;
    private WeakHashMap listener2SelectiveListener = new WeakHashMap();
    private AWTPermission listenToAllAWTEventsPermission = null;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$awt$event$AWTEventListener;

    protected abstract ButtonPeer createButton(Button var1) throws HeadlessException;

    protected abstract TextFieldPeer createTextField(TextField var1) throws HeadlessException;

    protected abstract LabelPeer createLabel(Label var1) throws HeadlessException;

    protected abstract ListPeer createList(List var1) throws HeadlessException;

    protected abstract CheckboxPeer createCheckbox(Checkbox var1) throws HeadlessException;

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1) throws HeadlessException;

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1) throws HeadlessException;

    protected abstract TextAreaPeer createTextArea(TextArea var1) throws HeadlessException;

    protected abstract ChoicePeer createChoice(Choice var1) throws HeadlessException;

    protected abstract FramePeer createFrame(Frame var1) throws HeadlessException;

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1) throws HeadlessException;

    protected abstract DialogPeer createDialog(Dialog var1) throws HeadlessException;

    protected abstract MenuBarPeer createMenuBar(MenuBar var1) throws HeadlessException;

    protected abstract MenuPeer createMenu(Menu var1) throws HeadlessException;

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1) throws HeadlessException;

    protected abstract MenuItemPeer createMenuItem(MenuItem var1) throws HeadlessException;

    protected abstract FileDialogPeer createFileDialog(FileDialog var1) throws HeadlessException;

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1) throws HeadlessException;

    protected LightweightPeer createComponent(Component component) {
        if (lightweightMarker == null) {
            lightweightMarker = new NullComponentPeer();
        }
        return lightweightMarker;
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] nArray) throws HeadlessException {
    }

    public void setDynamicLayout(boolean bl2) throws HeadlessException {
    }

    protected boolean isDynamicLayoutSet() throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isDynamicLayoutSet();
        }
        return false;
    }

    public boolean isDynamicLayoutActive() throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isDynamicLayoutActive();
        }
        return false;
    }

    public abstract Dimension getScreenSize() throws HeadlessException;

    public abstract int getScreenResolution() throws HeadlessException;

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        }
        return new Insets(0, 0, 0, 0);
    }

    public abstract ColorModel getColorModel() throws HeadlessException;

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    private static void loadAssistiveTechnologies() {
        final String string = File.separator;
        final Properties properties = new Properties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                try {
                    object = new File(System.getProperty("java.home") + string + "lib" + string + "accessibility.properties");
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = System.getProperty("javax.accessibility.screen_magnifier_present");
                if (object == null && (object = properties.getProperty("screen_magnifier_present", null)) != null) {
                    System.setProperty("javax.accessibility.screen_magnifier_present", (String)object);
                }
                return null;
            }
        });
        String string2 = properties.getProperty("assistive_technologies", null);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    Class clazz = classLoader != null ? classLoader.loadClass(string3) : Class.forName(string3);
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Assistive Technology not found: " + string3);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Assistive Technology: " + string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Assistive Technology: " + string3);
                }
                catch (Exception exception) {
                    throw new AWTError("Error trying to install Assistive Technology: " + string3 + " " + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Toolkit getDefaultToolkit() {
        if (toolkit == null) {
            try {
                Compiler.disable();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String string = null;
                        Class clazz = null;
                        try {
                            block9: {
                                string = System.getProperty("awt.toolkit", "sun.awt.motif.MToolkit");
                                try {
                                    clazz = Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                    if (classLoader == null) break block9;
                                    try {
                                        clazz = classLoader.loadClass(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        throw new AWTError("Toolkit not found: " + string);
                                    }
                                }
                            }
                            if (clazz != null) {
                                Toolkit.toolkit = (Toolkit)clazz.newInstance();
                                if (GraphicsEnvironment.isHeadless()) {
                                    Toolkit.toolkit = (Toolkit)new HeadlessToolkit(toolkit);
                                }
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            throw new AWTError("Could not instantiate Toolkit: " + string);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new AWTError("Could not access Toolkit: " + string);
                        }
                        return null;
                    }
                });
                Toolkit.loadAssistiveTechnologies();
                Object var1 = null;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                Compiler.enable();
                throw throwable;
            }
            Compiler.enable();
            {
            }
        }
        return toolkit;
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getPrintJob(frame, string, jobAttributes, pageAttributes);
        }
        return this.getPrintJob(frame, string, null);
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard() throws HeadlessException;

    public Clipboard getSystemSelection() throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getSystemSelection();
        }
        GraphicsEnvironment.checkHeadless();
        return null;
    }

    public int getMenuShortcutKeyMask() throws HeadlessException {
        return 2;
    }

    public boolean getLockingKeyState(int n2) throws UnsupportedOperationException {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
    }

    public void setLockingKeyState(int n2, boolean bl2) throws UnsupportedOperationException {
        if (n2 != 20 && n2 != 144 && n2 != 145 && n2 != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        throw new UnsupportedOperationException("Toolkit.setLockingKeyState");
    }

    protected static Container getNativeContainer(Component component) {
        return component.getNativeContainer();
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, point, string);
        }
        return new Cursor(0);
    }

    public Dimension getBestCursorSize(int n2, int n3) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getBestCursorSize(n2, n3);
        }
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().getMaximumCursorColors();
        }
        return 0;
    }

    public boolean isFrameStateSupported(int n2) throws HeadlessException {
        if (this != Toolkit.getDefaultToolkit()) {
            return Toolkit.getDefaultToolkit().isFrameStateSupported(n2);
        }
        return n2 == 0;
    }

    private static native void initIDs();

    static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    public static String getProperty(String string, String string2) {
        if (resources != null) {
            try {
                return resources.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return string2;
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    static EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueueImpl();
    }

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1) throws InvalidDnDOperationException;

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        return null;
    }

    public final synchronized Object getDesktopProperty(String string) {
        if (this instanceof HeadlessToolkit) {
            return ((HeadlessToolkit)this).getUnderlyingToolkit().getDesktopProperty(string);
        }
        if (this.desktopProperties.isEmpty()) {
            this.initializeDesktopProperties();
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            Object object = this.lazilyLoadDesktopProperty(string);
            return object;
        }
        Object object = this.desktopProperties.get(string);
        if (object == null && (object = this.lazilyLoadDesktopProperty(string)) != null) {
            this.setDesktopProperty(string, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDesktopProperty(String string, Object object) {
        Object object2;
        if (this instanceof HeadlessToolkit) {
            ((HeadlessToolkit)this).getUnderlyingToolkit().setDesktopProperty(string, object);
            return;
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            object2 = this.desktopProperties.get(string);
            this.desktopProperties.put(string, object);
        }
        this.desktopPropsSupport.firePropertyChange(string, object2, object);
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.desktopPropsSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.desktopPropsSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.desktopPropsSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.desktopPropsSupport.getPropertyChangeListeners(string);
    }

    private static AWTEventListener deProxyAWTEventListener(AWTEventListener aWTEventListener) {
        AWTEventListener aWTEventListener2 = aWTEventListener;
        if (aWTEventListener2 == null) {
            return null;
        }
        if (aWTEventListener instanceof AWTEventListenerProxy) {
            aWTEventListener2 = (AWTEventListener)((AWTEventListenerProxy)aWTEventListener).getListener();
        }
        return aWTEventListener2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAWTEventListener(AWTEventListener aWTEventListener, long l2) {
        AWTEventListener aWTEventListener2 = Toolkit.deProxyAWTEventListener(aWTEventListener);
        if (aWTEventListener2 == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener2);
            if (selectiveAWTEventListener == null) {
                selectiveAWTEventListener = new SelectiveAWTEventListener(aWTEventListener2, l2);
                this.listener2SelectiveListener.put(aWTEventListener2, selectiveAWTEventListener);
                this.eventListener = ToolkitEventMulticaster.add(this.eventListener, selectiveAWTEventListener);
            }
            selectiveAWTEventListener.orEventMasks(l2);
            long l3 = l2;
            int n2 = 0;
            while (n2 < 64) {
                if (l3 == 0L) break;
                if ((l3 & 1L) != 0L) {
                    int n3 = n2;
                    this.calls[n3] = this.calls[n3] + 1;
                }
                l3 >>>= 1;
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAWTEventListener(AWTEventListener aWTEventListener) {
        AWTEventListener aWTEventListener2 = Toolkit.deProxyAWTEventListener(aWTEventListener);
        if (aWTEventListener == null) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)this.listener2SelectiveListener.get(aWTEventListener2);
            if (selectiveAWTEventListener != null) {
                this.listener2SelectiveListener.remove(aWTEventListener2);
                int[] nArray = selectiveAWTEventListener.getCalls();
                int n2 = 0;
                while (n2 < 64) {
                    int n3 = n2;
                    this.calls[n3] = this.calls[n3] - nArray[n2];
                    ++n2;
                }
            }
            this.eventListener = ToolkitEventMulticaster.remove(this.eventListener, selectiveAWTEventListener == null ? aWTEventListener2 : selectiveAWTEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean enabledOnToolkit(long l2) {
        Toolkit toolkit;
        Class clazz = class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = Toolkit.class$("java.awt.Toolkit")) : class$java$awt$Toolkit;
        synchronized (clazz) {
            toolkit = Toolkit.toolkit;
        }
        return toolkit != null ? toolkit.countAWTEventListeners(l2) > 0 : false;
    }

    synchronized int countAWTEventListeners(long l2) {
        int n2 = 0;
        while (l2 != 0L) {
            l2 >>>= 1;
            ++n2;
        }
        return this.calls[--n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEventListener[] getAWTEventListeners() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            EventListener[] eventListenerArray = ToolkitEventMulticaster.getListeners(this.eventListener, class$java$awt$event$AWTEventListener == null ? (class$java$awt$event$AWTEventListener = Toolkit.class$("java.awt.event.AWTEventListener")) : class$java$awt$event$AWTEventListener);
            AWTEventListener[] aWTEventListenerArray = new AWTEventListener[eventListenerArray.length];
            int n2 = 0;
            while (n2 < eventListenerArray.length) {
                SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)eventListenerArray[n2];
                AWTEventListener aWTEventListener = selectiveAWTEventListener.getListener();
                aWTEventListenerArray[n2] = new AWTEventListenerProxy(selectiveAWTEventListener.getEventMask(), aWTEventListener);
                ++n2;
            }
            return aWTEventListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEventListener[] getAWTEventListeners(long l2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.listenToAllAWTEventsPermission == null) {
                this.listenToAllAWTEventsPermission = new AWTPermission("listenToAllAWTEvents");
            }
            securityManager.checkPermission(this.listenToAllAWTEventsPermission);
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            EventListener[] eventListenerArray = ToolkitEventMulticaster.getListeners(this.eventListener, class$java$awt$event$AWTEventListener == null ? (class$java$awt$event$AWTEventListener = Toolkit.class$("java.awt.event.AWTEventListener")) : class$java$awt$event$AWTEventListener);
            ArrayList arrayList = new ArrayList(eventListenerArray.length);
            int n2 = 0;
            while (n2 < eventListenerArray.length) {
                SelectiveAWTEventListener selectiveAWTEventListener = (SelectiveAWTEventListener)eventListenerArray[n2];
                if ((selectiveAWTEventListener.getEventMask() & l2) == l2) {
                    arrayList.add(new AWTEventListenerProxy(selectiveAWTEventListener.getEventMask(), selectiveAWTEventListener.getListener()));
                }
                ++n2;
            }
            return (AWTEventListener[])arrayList.toArray(new AWTEventListener[0]);
        }
    }

    void notifyAWTEventListeners(AWTEvent aWTEvent) {
        if (this instanceof HeadlessToolkit) {
            ((HeadlessToolkit)this).getUnderlyingToolkit().notifyAWTEventListeners(aWTEvent);
            return;
        }
        AWTEventListener aWTEventListener = this.eventListener;
        if (aWTEventListener != null) {
            aWTEventListener.eventDispatched(aWTEvent);
        }
    }

    public abstract Map mapInputMethodHighlight(InputMethodHighlight var1) throws HeadlessException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        loaded = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    resources = ResourceBundle.getBundle("sun.awt.resources.awt");
                }
                catch (MissingResourceException missingResourceException) {}
                return null;
            }
        });
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Toolkit.initIDs();
        }
        dbg = DebugHelper.create(class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = Toolkit.class$("java.awt.Toolkit")) : class$java$awt$Toolkit);
    }

    private class SelectiveAWTEventListener
    implements AWTEventListener {
        AWTEventListener listener;
        private long eventMask;
        int[] calls = new int[64];

        public AWTEventListener getListener() {
            return this.listener;
        }

        public long getEventMask() {
            return this.eventMask;
        }

        public int[] getCalls() {
            return this.calls;
        }

        public void orEventMasks(long l2) {
            this.eventMask |= l2;
            int n2 = 0;
            while (n2 < 64) {
                if (l2 == 0L) break;
                if ((l2 & 1L) != 0L) {
                    int n3 = n2;
                    this.calls[n3] = this.calls[n3] + 1;
                }
                l2 >>>= 1;
                ++n2;
            }
        }

        SelectiveAWTEventListener(AWTEventListener aWTEventListener, long l2) {
            this.listener = aWTEventListener;
            this.eventMask = l2;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            long l2 = 0L;
            l2 = this.eventMask & 1L;
            if (l2 != 0L && aWTEvent.id >= 100 && aWTEvent.id <= 103 || (l2 = this.eventMask & 2L) != 0L && aWTEvent.id >= 300 && aWTEvent.id <= 301 || (l2 = this.eventMask & 4L) != 0L && aWTEvent.id >= 1004 && aWTEvent.id <= 1005 || (l2 = this.eventMask & 8L) != 0L && aWTEvent.id >= 400 && aWTEvent.id <= 402 || (l2 = this.eventMask & 0x20000L) != 0L && aWTEvent.id == 507 || (l2 = this.eventMask & 0x20L) != 0L && (aWTEvent.id == 503 || aWTEvent.id == 506) || (l2 = this.eventMask & 0x10L) != 0L && aWTEvent.id != 503 && aWTEvent.id != 506 && aWTEvent.id != 507 && aWTEvent.id >= 500 && aWTEvent.id <= 507 || (l2 = this.eventMask & 0x40L) != 0L && aWTEvent.id >= 200 && aWTEvent.id <= 209 || (l2 = this.eventMask & 0x80L) != 0L && aWTEvent.id >= 1001 && aWTEvent.id <= 1001 || (l2 = this.eventMask & 0x100L) != 0L && aWTEvent.id >= 601 && aWTEvent.id <= 601 || (l2 = this.eventMask & 0x200L) != 0L && aWTEvent.id >= 701 && aWTEvent.id <= 701 || (l2 = this.eventMask & 0x400L) != 0L && aWTEvent.id >= 900 && aWTEvent.id <= 900 || (l2 = this.eventMask & 0x800L) != 0L && aWTEvent.id >= 1100 && aWTEvent.id <= 1101 || (l2 = this.eventMask & 0x2000L) != 0L && aWTEvent.id >= 800 && aWTEvent.id <= 801 || (l2 = this.eventMask & 0x4000L) != 0L && aWTEvent.id >= 1200 && aWTEvent.id <= 1200 || (l2 = this.eventMask & 0x8000L) != 0L && aWTEvent.id == 1400 || (l2 = this.eventMask & 0x10000L) != 0L && (aWTEvent.id == 1401 || aWTEvent.id == 1402) || (l2 = this.eventMask & 0x40000L) != 0L && aWTEvent.id == 209 || (l2 = this.eventMask & 0x80000L) != 0L && (aWTEvent.id == 207 || aWTEvent.id == 208)) {
                int n2 = 0;
                long l3 = l2;
                while (l3 != 0L) {
                    l3 >>>= 1;
                    ++n2;
                }
                --n2;
                int n3 = 0;
                while (n3 < this.calls[n2]) {
                    this.listener.eventDispatched(aWTEvent);
                    ++n3;
                }
            }
        }
    }

    private static class ToolkitEventMulticaster
    extends AWTEventMulticaster
    implements AWTEventListener {
        ToolkitEventMulticaster(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            super(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener add(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            if (aWTEventListener == null) {
                return aWTEventListener2;
            }
            if (aWTEventListener2 == null) {
                return aWTEventListener;
            }
            return new ToolkitEventMulticaster(aWTEventListener, aWTEventListener2);
        }

        static AWTEventListener remove(AWTEventListener aWTEventListener, AWTEventListener aWTEventListener2) {
            return (AWTEventListener)AWTEventMulticaster.removeInternal(aWTEventListener, aWTEventListener2);
        }

        protected EventListener remove(EventListener eventListener) {
            if (eventListener == this.a) {
                return this.b;
            }
            if (eventListener == this.b) {
                return this.a;
            }
            AWTEventListener aWTEventListener = (AWTEventListener)AWTEventMulticaster.removeInternal(this.a, eventListener);
            AWTEventListener aWTEventListener2 = (AWTEventListener)AWTEventMulticaster.removeInternal(this.b, eventListener);
            if (aWTEventListener == this.a && aWTEventListener2 == this.b) {
                return this;
            }
            return ToolkitEventMulticaster.add(aWTEventListener, aWTEventListener2);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            ((AWTEventListener)this.a).eventDispatched(aWTEvent);
            ((AWTEventListener)this.b).eventDispatched(aWTEvent);
        }
    }
}

