/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsPopupMenuUI
extends BasicPopupMenuUI {
    static MnemonicListener mnemonicListener = null;
    static KeyEventPostProcessor altProcessor = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsPopupMenuUI();
    }

    public void installListeners() {
        super.installListeners();
        if (!UIManager.getBoolean("Button.showMnemonics") && mnemonicListener == null) {
            mnemonicListener = new MnemonicListener();
            MenuSelectionManager.defaultManager().addChangeListener(mnemonicListener);
        }
        if (altProcessor == null) {
            altProcessor = new AltProcessor();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(altProcessor);
        }
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n2, int n3) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup(jPopupMenu.getInvoker(), jPopupMenu, n2, n3);
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;

        AltProcessor() {
        }

        void altPressed() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0 && !(menuElementArray[0] instanceof ComboPopup)) {
                menuSelectionManager.clearSelectedPath();
                menuCanceledOnPress = true;
            } else {
                menuCanceledOnPress = false;
            }
        }

        void altReleased(KeyEvent keyEvent) {
            if (menuCanceledOnPress) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                JMenu jMenu;
                JRootPane jRootPane = SwingUtilities.getRootPane(keyEvent.getComponent());
                Window window = SwingUtilities.getWindowAncestor(jRootPane);
                JMenuBar jMenuBar = jRootPane != null ? jRootPane.getJMenuBar() : null;
                JMenu jMenu2 = jMenu = jMenuBar != null ? jMenuBar.getMenu(0) : null;
                if (jMenu != null) {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 18) {
                if (keyEvent.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed();
                    }
                    altKeyPressed = true;
                } else if (keyEvent.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(keyEvent);
                    }
                    altKeyPressed = false;
                }
            } else {
                altKeyPressed = false;
            }
            return false;
        }
    }

    static class MnemonicListener
    implements ChangeListener {
        JRootPane repaintRoot = null;

        MnemonicListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length == 0) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                if (this.repaintRoot != null) {
                    this.repaintRoot.repaint();
                }
            } else {
                Component component = (Component)((Object)menuElementArray[0]);
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.repaintRoot = SwingUtilities.getRootPane(component);
            }
        }
    }
}

