/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static Method hasStaticInitializerMethod = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectStreamClass;
    static /* synthetic */ Class class$java$lang$Class;

    public static long computeSerialVersionUID(Class clazz) {
        long l2 = ObjectStreamClass.getSerialVersionUID(clazz);
        if (l2 == 0L) {
            return l2;
        }
        l2 = ObjectStreamClassUtil_1_3.getSerialVersion(l2, clazz);
        return l2;
    }

    private static Long getSerialVersion(final long l2, final Class clazz) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                long l22;
                try {
                    Field field = clazz.getDeclaredField("serialVersionUID");
                    int n2 = field.getModifiers();
                    l22 = Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2) ? l2 : ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    l22 = ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                return new Long(l22);
            }
        });
    }

    public static long computeStructuralUID(boolean bl2, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            int n2;
            Object object;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClassUtil_1_3.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClassUtil_1_3.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClassUtil_1_3.class$("java.lang.Object")) : class$java$lang$Object)) {
                boolean bl3 = false;
                Class[] classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClassUtil_1_3.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                object = ObjectStreamClassUtil_1_3.getDeclaredMethod(clazz2, "writeObject", classArray, 2, 8);
                if (object != null) {
                    bl3 = true;
                }
                dataOutputStream.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(bl3, clazz2));
            }
            if (bl2) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Object[] objectArray = ObjectStreamClassUtil_1_3.getDeclaredFields(clazz);
            Arrays.sort(objectArray, compareMemberByName);
            int n3 = 0;
            while (n3 < objectArray.length) {
                object = objectArray[n3];
                n2 = ((Field)object).getModifiers();
                if (!Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    dataOutputStream.writeUTF(((Field)object).getName());
                    dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)object).getType()));
                }
                ++n3;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n4 = n2 = Math.min(8, ((Object)object).length);
            while (n4 > 0) {
                l2 += (long)(object[n4] & 0xFF) << n4 * 8;
                --n4;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            Object object;
            Object object2;
            int n2;
            MethodSignature[] methodSignatureArray;
            int n3;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n4 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n4 &= 0x611) & 0x200) != 0) {
                n4 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n4 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n4);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                n3 = 0;
                while (n3 < objectArray.length) {
                    dataOutputStream.writeUTF(((Class)objectArray[n3]).getName());
                    ++n3;
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            n3 = 0;
            while (n3 < objectArray.length) {
                methodSignatureArray = objectArray[n3];
                n2 = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n2) || !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(methodSignatureArray.getType()));
                }
                ++n3;
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            n2 = 0;
            while (n2 < methodSignatureArray.length) {
                object2 = methodSignatureArray[n2];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n2;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n5 = 0;
            while (n5 < ((MethodSignature[])object2).length) {
                object = object2[n5];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n5;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n6 = 0;
            while (n6 < Math.min(8, ((Object)object).length)) {
                l2 += (long)(object[n6] & 0xFF) << n6 * 8;
                ++n6;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("[");
                ++n3;
            }
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Serializable serializable;
        if (hasStaticInitializerMethod == null) {
            serializable = null;
            try {
                try {
                    serializable = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (serializable == null) {
                    serializable = class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = ObjectStreamClassUtil_1_3.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass;
                }
                hasStaticInitializerMethod = ((Class)serializable).getDeclaredMethod("hasStaticInitializer", new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClassUtil_1_3.class$("java.lang.Class")) : class$java$lang$Class});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + ((Class)serializable).getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            serializable = (Boolean)hasStaticInitializerMethod.invoke(null, new Object[]{clazz});
            return (Boolean)serializable;
        }
        catch (Exception exception) {
            throw new InternalError("Error invoking hasStaticInitializer: " + exception);
        }
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray, final int n2, final int n3) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                    int n22 = method.getModifiers();
                    if ((n22 & n3) != 0 || (n22 & n2) != n2) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                return method;
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n3].getModifiers())) {
                    ++n2;
                }
                ++n3;
            }
            Object[] objectArray = new MethodSignature[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n5].getModifiers())) {
                    objectArray[n4] = new MethodSignature(memberArray[n5]);
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.getSignature((Constructor)member) : ObjectStreamClassUtil_1_3.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Method)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }
}

