/***************************************************************************
                            KWordWrap.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KWORDWRAP_H
#define KWORDWRAP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.

 Usage: call the static method, @ref formatText, with the text to
 wrap and the constraining rectangle etc., it will return an instance of KWordWrap
 containing internal data, result of the word-wrapping.
 From that instance you can retrieve the boundingRect, and invoke drawing.

 This design allows to call the word-wrap algorithm only when the text changes
 and not every time we want to know the bounding rect or draw the text.
 
 @short 
 Word-wrap algorithm that takes into account beautifulness ;)
 That means: not letting a letter alone on the last line,
 breaking at punctuation signs, etc.
*/

@class QRect;
@class QPainter;
@class QFontMetrics;

@interface  KWordWrap : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 

*/
- (QRect*) boundingRect;

/** 

*/
- (NSString *) wrappedString;

/** 

*/
- (NSString *) truncatedString: (BOOL)dots;

/** 
 Draw the text that has been previously wrapped, at position x,y.
 Flags are for alignment, e.g. AlignHCenter. Default is AlignAuto.
     
*/
- drawText: (QPainter *)painter x: (int)x y: (int)y flags: (int)flags;
- drawText: (QPainter *)painter x: (int)x y: (int)y ;

/** 
 Main method for wrapping text.

*/
+ (KWordWrap*) formatText: (QFontMetrics *)fm r: (QRect*)r flags: (int)flags str: (NSString *)str len: (int)len;
+ (KWordWrap*) formatText: (QFontMetrics *)fm r: (QRect*)r flags: (int)flags str: (NSString *)str ;
@end

#endif
