/***************************************************************************
                            KSaveFile.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSAVEFILE_H
#define KSAVEFILE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The KSaveFile class has been made to write out changes to an existing
 file atomically.
 This means that EITHER:
 a)
   All changes have been written successfully to the file.

 b)
   Some error occured, no changes have been written whatsoever and the
   old file is still in place.
 
 @short 
 The KSaveFile class has been made to write out changes to an existing
 file atomically.
*/
@class QDataStream; 
@class QFile; 
@class QTextStream; 

@interface  KSaveFile : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- initWithText: (NSString *)filename mode: (int)mode;
- initWithText: (NSString *)filename ;

/** 
 The destructor closes the file.

*/
- (void) dealloc;

/** 
 Returns the status of the file based on errno. (see errno.h)
 0 means OK.

 You should check the status after object creation to check
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
- (int) status;

/** 
 The name of the file as passed to the constructor.

*/
- (NSString *) name;

/** 
 An integer file descriptor open for writing to the file.

*/
- (int) handle;

/** 
 A FILE* stream open for writing to the file.

*/
//- (FILE*) fstream;

/** 
 A QFile* open for writing to the file.

*/
- (QFile*) file;

/** 
 A QTextStream* open for writing to the file.

*/
- (QTextStream*) textStream;

/** 
 A QDataStream* open for writing to the file.

*/
- (QDataStream*) dataStream;

/** 
 Aborts the write operation and removes any intermediate files
 This implies a close.

*/
- abort;

/** 
 Closes the file and makes the changes definitive.
 Returns 'true' is successful, or 'false' if an error has occured.
 See -status for details about errors.

*/
- (BOOL) close;
@end

#endif
