/***************************************************************************
                            Part.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Base class for parts.

 A "part" is a GUI component, featuring:

 See also {@link ReadOnlyPart} and {@link ReadWritePart}, which define the
 framework for a "viewer" part and for an "editor"-like part.
 Use Part directly only if your part doesn't fit into those.
 
 See {@link PartSignals} for signals emitted by Part.

 See {@link PartEventHandling} for event handlers to override in subclasses of Part.

 @short 
 Base class for parts.
*/
public class Part extends QObject implements  PartBaseInterface, KXMLGUIClientInterface {
	protected Part(Class dummy){super((Class) null);}

	private native void newPart( QObject parent, String name);

/** 
  Constructor.

*/
	public Part( QObject parent, String name) {
		super((Class) null);
		newPart( parent, name);
	}
	private native void newPart();
	public Part() {
		super((Class) null);
		newPart();
	}

/** 
  Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Embed this part into a host widget.

 You don't need to do this if you created the widget with the
 correct parent widget - this is just a {@link QWidget#reparent}.
 Note that the {@link Part} is still the holder
 of the {@link QWidget}, meaning that if you delete the {@link Part},
 then the widget gets destroyed as well, and vice-versa.
 This method is not recommended since creating the widget with the correct
 parent is simpler anyway.
     
*/
	public native void embed( QWidget parentWidget);

/** 

*/
	public native QWidget widget();

/** 

 Used by the part manager.
     
*/
	public native void setManager( PartManager manager);

/** 
 Returns the part manager handling this part, if any (null otherwise).
     
*/
	public native PartManager manager();

/** 

     
*/
	public native Part hitTest( QWidget widget, QPoint globalPos);

/** 

*/
	public native void setSelectable( boolean selectable);

/** 
  Returns whether the part is selectable or not.
     
*/
	public native boolean isSelectable();

/** 
 Set the main widget.

 Call this in the Part-inherited class constructor.
     
*/
	protected native void setWidget( QWidget widget);

/** 

     
*/
	public native boolean event( QEvent event);
	protected native void customEvent( QCustomEvent event);

/** 
 Convenience method which is called when the Part received a {@link PartActivateEvent} .
 Reimplement this if you don't want to reimplement {@link event} and test for the event yourself
 or even install an event filter.
     
*/
	protected native void partActivateEvent( PartActivateEvent event);

/** 
 Convenience method which is called when the Part received a
 {@link PartSelectEvent} .
 Reimplement this if you don't want to reimplement {@link event} and
 test for the event yourself or even install an event filter.
     
*/
	protected native void partSelectEvent( PartSelectEvent event);

/** 
 Convenience method which is called when the Part received a
 {@link GUIActivateEvent} .
 Reimplement this if you don't want to reimplement {@link event} and
 test for the event yourself or even install an event filter.
     
*/
	protected native void guiActivateEvent( GUIActivateEvent event);

/** 
 Convenience method for {@link KXMLGUIFactory#container}.

*/
	protected native QWidget hostContainer( String containerName);
	
	// From KXMLGUIClientInterface
/**
 Retrieves an action of the client by name.
 This method is provided for convenience, as it uses {@link #actionCollection}
 to get the action object.

*/
	public native KAction action( String name);

/**
 Retrieves an action for a given {@link QDomElement}. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.

*/
	public native KAction action( QDomElement element);

/**
 Retrieves the entire action collection for the GUI client

*/
	public native KActionCollection actionCollection();

/**

*/
	public native KInstanceInterface instance();

/**

*/
	public native QDomDocument domDocument();

/**
 This will return the name of the XML file as set by {@link #setXMLFile}.
 If {@link #setXML} is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
	public native String xmlFile();
	public native String localXMLFile();

/**


*/
	public native void setXMLGUIBuildDocument( QDomDocument doc);

/**


*/
	public native QDomDocument xmlguiBuildDocument();

/**
 This method is called by the {@link KXMLGUIFactory} as soon as the client
 is added to the KXMLGUIFactory's GUI.

*/
	public native void setFactory( KXMLGUIFactory factory);

/**
 Retrieves a pointer to the {@link KXMLGUIFactory} this client is
 associated with (will return null if the client's GUI has not been built
 by a KXMLGUIFactory.

*/
	public native KXMLGUIFactory factory();

/**
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or null if it has no
 parent client assigned.

*/
	public native KXMLGUIClientInterface parentClient();

/**
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.

*/
	public native void insertChildClient( KXMLGUIClientInterface child);

/**
 Removes the given <code>child</code> from the client's children list.

*/
	public native void removeChildClient( KXMLGUIClientInterface child);

/**
 Retrieves a list of all child clients.

*/
//	public native KXMLGUIClientPtrList childClients();

/**
 A client can have an own {@link KXMLGUIBuilder}.
 Use this method to assign your builder instance to the client (so that the
 {@link KXMLGUIFactory} can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.

*/
	public native void setClientBuilder( KXMLGUIBuilderInterface builder);

/**
 Retrieves the client's GUI builder or null if no client specific
 builder has been assigned via {@link #setClientBuilder}

*/
	public native KXMLGUIBuilderInterface clientBuilder();

/**
 Forces this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.

*/
	public native void reloadXML();
//	public native void plugActionList( String name, KActionPtrList actionList);
	public native void unplugActionList( String name);
	public native void addStateActionEnabled( String state, String action);
	public native void addStateActionDisabled( String state, String action);
//	public native StateChange getActionsToChangeForState( String state);
	public static native String findMostRecentXMLFile( String[] files, String doc);

/**
 Sets the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor.
 (At least before {@link #setXMLFile}.)

*/
	public native void setInstance( KInstanceInterface instance);

/**
 Sets the name of the rc file containing the XML for the part.

 Call this in the Part-inherited class constructor.

*/
	protected native void setXMLFile( String file, boolean merge, boolean setXMLDoc);
	protected native void setXMLFile( String file);
	protected native void setLocalXMLFile( String file);

/**
 Sets the XML for the part.

 Call this in the Part-inherited class constructor if you
  don't call {@link #setXMLFile}.

*/
	protected native void setXML( String document, boolean merge);
	protected native void setXML( String document);

/**
 Sets the Document for the part, describing the layout of the GUI.

 Call this in the Part-inherited class constructor if you don't call
 {@link setXMLFile} or {@link setXML} .

*/
	protected native void setDOMDocument( QDomDocument document, boolean merge);
	protected native void setDOMDocument( QDomDocument document);

/**
 This function will attempt to give up some memory after the GUI
 is built.  It should never be used in apps where the GUI may be
 rebuilt at some later time (components, for instance).

*/
	protected native void conserveMemory();
	protected native void stateChanged( String newstate);

	// From PartBaseInterface
/**
  Internal method. Called by {@link KParts#Part} to specify the parent object for plugin objects.


*/
	public native void setPartObject( QObject object);
	public native QObject partObject();

}
