/***************************************************************************
                            NoteArray.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Holds a resizeable array of note on/off and patch change events. It can
 increase it size, but it doesn't decreases (until destruction :-) )

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Stores an array of note on/off events.
*/
public class  NoteArray implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected NoteArray(Class dummy){}

	private native void newNoteArray();

/** 
 Constructor. Initializes internal variables.
   
*/
	public NoteArray() {
		newNoteArray();
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Adds (or modifies) an event in the given position . 

 Note that this has nothing to do with what is being played, this just
 modifies an internal array.
   
*/
	public native void at( long pos, long ms, int chn, int cmd, int note);

/** 
 A convenience function, which differs from the above in the parameters
 it accepts.
   
*/
	public native void at( long pos, int s);

/** 
 Returns the note event at a given position.
   
*/
	public native int at( int pos);

/** 
 Adds a note/patch event at a given millisecond.

 Note: This method always appends at the end of the list.
   
*/
	public native void add( long ms, int chn, int cmd, int note);

/** 
 Initializes the iterator.

*/
	public native void iteratorBegin();

/** 
 Get the command currently pointed to by the iterator.
   
*/
	public native int get();

/** 
 Advances the iterator to the next position.
   
*/
	public native void next();

/** 
 Calls {@link #next} until the next event is over ms milliseconds
 and puts in <code>pgm</code>[16] the instruments used at this moment.
   
*/
	public native void moveIteratorTo( long ms, int[] pgm);
	public native void moveIteratorTo( long ms);
}
