package org.kde.koala;
import org.kde.qt.*;


/** {@link KSpell} emits these signals */
public interface KSpellSignals {

/** 
 Emitted whenever a misspelled word is found by {@link KSpell#check} or
   by {@link KSpell#checkWord}.
  If it is emitted by {@link KSpell#checkWord}, <code>pos</code>=0.
  If it is emitted by {@link KSpell#check}, then <code>pos</code> indicates the position of
   the misspelled word in the (original) <code>_buffer.</code>
   (The first position is zero.)
  If it is emitted by {@link KSpell#checkList}, <code>pos</code> is the index to
  the misspelled
   word in the {@link StringList} passed to {@link KSpell#checkList}.
  Note, that <code>originalword</code> can be only a word part, if it's
  word with hyphens.

  These are called _before_ the dialog is opened, so that the
   calling program's GUI may be updated. (e.g. the misspelled word may
   be highlighted).
   
*/
	void misspelling( String originalword, String[] suggestions, int pos );
	void destroyed( QObject obj );

/** 
 Emitted on terminal errors and after clean up.

 You can delete the KSpell object in this signal.

 You can check {@link KSpell#status} to see what caused the death:

*/
	void death();

/** 
 Emitted when {@link KSpell#checkList} is done.

 If the argument is
 <code>true</code>, then you should update your text from the
 wordlist, otherwise not.
   
*/
	void done( boolean arg1 );
	void dialog3();

/** 
 Emmited when the user pressed "Ignore" in the dialog.
 Don't know if this could be usefull.

   
*/
	void ignoreword( String originalword );
	void ez();

/** 
 Emitted after KSpell has verified that ISpell/ASpell is running
 and working properly.  
   
*/
	void ready( KSpell arg1 );
	void eza();

/** 
 Emitted after the "Replace" or "Replace All" buttons of the dialog
 was pressed, or if the word was 
 corrected without calling the dialog (i.e., the user previously chose
 "Replace All" for this word). 

 Results from the dialog may be checked with {@link KSpell#dlgResult}
  and {@link KSpell#replacement}.

 Note, that when using {@link KSpell#checkList} this signal cann occure
 more then once with same list position, when checking a word with
 hyphens. In this case <code>orignalword</code> is the last replacement.

*/
	void corrected( String originalword, String newword, int pos );

/** 
 Emitted during a {@link KSpell#check}.
 <code>i</code> is between 1 and 100.
   
*/
	void progress( int i );

/** 
 Emitted when the user pressed "Add" in the dialog.
 This could be used to make an external user dictionary
 independent of the ISpell personal dictionary.

   
*/
	void addword( String originalword );

/** 
 Emitted when the user pressed "Ignore All" in the dialog.
 This could be used to make an application or file specific
 user dictionary.

   
*/
	void ignoreall( String originalword );
}

