package org.kde.koala;
import org.kde.qt.*;


/** {@link KScriptManager} emits these signals */
public interface KScriptManagerSignals {

/** 
	Send out a signal of the warning message from the current running
	script.
		
*/
	void scriptWarning( String msg );
	void destroyed( QObject obj );

/** 
	Send out a signal of the error message from the current running
	script.
		
*/
	void scriptError( String msg );

/** 
	Send out a signal of the exit status of the script

		
*/
	void scriptDone( int result, QVariant returned );

/** 
	Send out a signal of the progress of the current running
	script.
		
*/
	void scriptProgress( int percent );

/** 
	Send out a signal of the output message from the current running
	script.
		
*/
	void scriptOutput( String msg );
}

