/***************************************************************************
                            KRestrictedLine.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 The KRestrictedLine widget is a variant of {@link QLineEdit} which
 accepts only a restricted set of characters as input. 
 All other characters will be discarded and the signal {@link #invalidChar} 
 will be emitted for each of them.

 Valid characters can be passed as a String to the constructor
 or set afterwards via {@link #setValidChars}.
 The default key bindings of {@link QLineEdit} are still in effect.

 See {@link KRestrictedLineSignals} for signals emitted by KRestrictedLine.

 See {@link KRestrictedLineEventHandling} for event handlers to override in subclasses of KRestrictedLine.

 @author Michael Wiedmann <mw@miwie.in-berlin.de>

 @version 0.0.1
 
 @short A line editor for restricted character sets.

*/
public class KRestrictedLine extends KLineEdit  {
	protected KRestrictedLine(Class dummy){super((Class) null);}

	private native void newKRestrictedLine( QWidget parent, String name, String valid);

/** 
 Constructor: This contructor takes three - optional - arguments.
  The first two parameters are simply passed on to {@link QLineEdit}.

*/
	public KRestrictedLine( QWidget parent, String name, String valid) {
		super((Class) null);
		newKRestrictedLine( parent, name, valid);
	}
	private native void newKRestrictedLine();
	public KRestrictedLine() {
		super((Class) null);
		newKRestrictedLine();
	}

/** 
 Destructs the restricted line editor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 All characters in the string valid are treated as 
 acceptable characters.
   
*/
	public native void setValidChars( String valid);

/** 

*/
	public native String validChars();
}
