/***************************************************************************
                            KPasswordEdit.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 The widget uses the user's global "echo mode" setting.
 
 See {@link KPasswordEditSignals} for signals emitted by KPasswordEdit.

 See {@link KPasswordEditEventHandling} for event handlers to override in subclasses of KPasswordEdit.

 @author Geert Jansen <geertj@kde.org>

 @short A safe password input widget.

*/
public class KPasswordEdit extends QLineEdit  {
	protected KPasswordEdit(Class dummy){super((Class) null);}

	private native void newKPasswordEdit( QWidget parent, String name);

/** 
 Constructs a password input widget using the user's global "echo mode" setting.
     
*/
	public KPasswordEdit( QWidget parent, String name) {
		super((Class) null);
		newKPasswordEdit( parent, name);
	}
	private native void newKPasswordEdit();
	public KPasswordEdit() {
		super((Class) null);
		newKPasswordEdit();
	}
	private native void newKPasswordEdit( int echoMode, QWidget parent, String name);

/** 
 Constructs a password input widget using echoMode as "echo mode".

*/
	public KPasswordEdit( int echoMode, QWidget parent, String name) {
		super((Class) null);
		newKPasswordEdit( echoMode, parent, name);
	}
	private native void newKPasswordEdit( QWidget parent, String name, int echoMode);

/** 

 Creates a password input widget using echoMode as "echo mode".
     
*/
	public KPasswordEdit( QWidget parent, String name, int echoMode) {
		super((Class) null);
		newKPasswordEdit( parent, name, echoMode);
	}

/** 
 Destructs the widget.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/**  
 Returns the password. The memory is freed in the destructor
 so you should make a copy.
     
*/
	public native String password();

/** 
 Erases the current password.
     
*/
	public native void erase();
	protected native void keyPressEvent( QKeyEvent arg1);
	protected native void focusInEvent( QFocusEvent e);
	public native boolean event( QEvent e);
	public static final int OneStar = 0;
	public static final int ThreeStars = 1;
	public static final int NoEcho = 2;
}
