/***************************************************************************
                            KKeyDialog.java -  description
                             -------------------
    begin                : Tue Jan 29 14:32:25 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Jan 29 14:32:25 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KAccel and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. For example you could use KAccel and KKeyDialog like this

 <pre>
 KAccel keys;

 keys.insertItem( i18n( "Zoom in" ), "Zoom in", "+" );
 keys.connectItem( "Zoom in", myWindow, SLOT(" zoomIn()") );

 keys.connectItem( KAccel.Print, myWindow, SLOT(" print()") );

 keys.readSettings();

 if( KKeyDialog.configureKeys( &keys ) ) {
	      ...
 }
 </pre>

 This will also implicitly save the settings. If you don't want this,
 you can call

 <pre>
 if( KKeyDialog.configureKeys( &keys, false ) ) { // do not save settings
	      ...
 }
 </pre>

 For XML-UI applications, this is much simpler. All you need to do is
 <pre>
 KKeyDialog.configureKeys(actionCollection(), xmlFile());
 </pre>

 See {@link KKeyDialogSignals} for signals emitted by KKeyDialog.

 See {@link KKeyDialogEventHandling} for event handlers to override in subclasses of KKeyDialog.

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyDialog.java,v 1.9 2002/01/31 04:48:57 rdale Exp $

 @short Dialog for configuration of @ref KAccel and @ref KGlobalAccel.

*/
public class KKeyDialog extends KDialogBase  {
	protected KKeyDialog(Class dummy){super((Class) null);}

	private native void newKKeyDialog( boolean bAllowLetterShortcuts, QWidget parent, String name);
	public KKeyDialog( boolean bAllowLetterShortcuts, QWidget parent, String name) {
		super((Class) null);
		newKKeyDialog( bAllowLetterShortcuts, parent, name);
	}
	private native void newKKeyDialog();
	public KKeyDialog() {
		super((Class) null);
		newKKeyDialog();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native boolean insert( KActionCollection arg1);
	public native boolean configure( boolean bSaveSettings);
	public native boolean configure();
	public native void commitChanges();

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from a {@link KAccelBase} object, and the modifications are written to that object
 when the dialog is closed.

*/
	public static native int configure( KAccel keys, QWidget parent, boolean bSaveSettings);
	public static native int configure( KAccel keys);
	public static native int configure( KGlobalAccel keys, QWidget parent, boolean bSaveSettings);
	public static native int configure( KGlobalAccel keys);

/** 
 Pops up a modal dialog for configuring key settings. The dialog is initialized
 from an action collection (for XMLGUI based applications).

*/
	public static native int configure( KActionCollection coll, QWidget parent, boolean bSaveSettings);
	public static native int configure( KActionCollection coll);
	public static native int configureKeys( KAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KAccel keys);
	public static native int configureKeys( KGlobalAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KGlobalAccel keys);
	public static native int configureKeys( KActionCollection coll, String arg1, boolean save_settings, QWidget parent);
	public static native int configureKeys( KActionCollection coll, String arg1);
}
