package org.kde.koala;
import org.kde.qt.*;


/** Override these methods in subclasses of {@link KHTMLPart} to customise event handling behaviour */
public interface KHTMLPartEventHandling {

/** 
 Eventhandler for the khtml.MouseDoubleMoveEvent.
   
*/
	void khtmlMouseMoveEvent(MouseMoveEvent event);

/** 
 Convenience method which is called when the Part received a {@link PartActivateEvent} .
 Reimplement this if you don't want to reimplement {@link event} and test for the event yourself
 or even install an event filter.
     
*/
	void partActivateEvent(PartActivateEvent event);

/** 
 Convenience method which is called when the Part received a
 {@link PartSelectEvent} .
 Reimplement this if you don't want to reimplement {@link event} and
 test for the event yourself or even install an event filter.
     
*/
	void partSelectEvent(PartSelectEvent event);
	void childEvent(QChildEvent arg1);
	void customEvent(QCustomEvent event);

/** 
 Internal reimplementation of KParts.Part.guiActivateEvent .
   
*/
	void guiActivateEvent(GUIActivateEvent event);

/** 
 Eventhandler of the khtml.MousePressEvent.
   
*/
	void khtmlMousePressEvent(MousePressEvent event);

/** 
 Eventhandler for the khtml.MouseMoveEvent.
   
*/
	void khtmlMouseReleaseEvent(MouseReleaseEvent event);

/** 
 Eventhandler for the khtml.MouseDoubleClickEvent.
   
*/
	void khtmlMouseDoubleClickEvent(MouseDoubleClickEvent arg1);
	void timerEvent(QTimerEvent arg1);

/** 
 Eventhandler for the khtml.DrawContentsEvent.
   
*/
	void khtmlDrawContentsEvent(DrawContentsEvent arg1);
}

