/***************************************************************************
                            KDualColorButton.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDualColorButton allows the user to select two cascaded colors (usually a
 foreground and background color). Other features include drag and drop
 from other KDE color widgets, a reset to black and white control, and a
 swap colors control.

 When the user clicks on the foreground or background rectangle the
 rectangle is first sunken and the {@link #currentChanged} signal is emitted.
 Further clicks will present a color dialog and emit either the {@link #fgChanged}
 or {@link #bgChanged} if a new color is selected.

 Note: With drag and drop when dropping a color the current selected color
 will be set, while when dragging a color it will use whatever color
 rectangle the mouse was pressed inside.

 See {@link KDualColorButtonSignals} for signals emitted by KDualColorButton.

 See {@link KDualColorButtonEventHandling} for event handlers to override in subclasses of KDualColorButton.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A widget for selecting two related colors.

*/
public class KDualColorButton extends QWidget  {
	protected KDualColorButton(Class dummy){super((Class) null);}

	private native void newKDualColorButton( QWidget parent, String name, QWidget dialogParent);

/** 
 Constructs a new KDualColorButton using the default black and white
 colors.

     
*/
	public KDualColorButton( QWidget parent, String name, QWidget dialogParent) {
		super((Class) null);
		newKDualColorButton( parent, name, dialogParent);
	}
	private native void newKDualColorButton();
	public KDualColorButton() {
		super((Class) null);
		newKDualColorButton();
	}
	private native void newKDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name, QWidget dialogParent);

/** 
 Constructs a new KDualColorButton with the supplied foreground and
 background colors.
     
*/
	public KDualColorButton( QColor fgColor, QColor bgColor, QWidget parent, String name, QWidget dialogParent) {
		super((Class) null);
		newKDualColorButton( fgColor, bgColor, parent, name, dialogParent);
	}
	private native void newKDualColorButton( QColor fgColor, QColor bgColor);
	public KDualColorButton( QColor fgColor, QColor bgColor) {
		super((Class) null);
		newKDualColorButton( fgColor, bgColor);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the current foreground color.
     
*/
	public native QColor foreground();

/** 
 Returns the current background color.
     
*/
	public native QColor background();

/** 
 Returns the current color item selected by the user.
     
*/
	public native int current();

/** 
 Returns the color of the selected item.
     
*/
	public native QColor currentColor();

/** 
 Returns the minimum size needed to display the widget and all its
 controls.
     
*/
	public native QSize sizeHint();

/** 
 Sets the foreground color.
     
*/
	public native void setForeground( QColor c);

/** 
 Sets the background color.
     
*/
	public native void setBackground( QColor c);

/** 
 Sets the current selected color item.
     
*/
	public native void setCurrent( int s);

/** 
 Sets the color of the selected item.
     
*/
	public native void setCurrentColor( QColor c);

/** 
 Sets the supplied rectangles to the proper size and position for the
 current widget size. You can reimplement this to change the layout
 of the widget. Restrictions are that the swap control will always
 be at the top right, the reset control will always be at the bottom
 left, and you must leave at least a 14x14 space in those corners.
     
*/
	protected native void metrics( QRect fgRect, QRect bgRect);
	protected native void paintEvent( QPaintEvent ev);
	protected native void mousePressEvent( QMouseEvent ev);
	protected native void mouseMoveEvent( QMouseEvent ev);
	protected native void mouseReleaseEvent( QMouseEvent ev);
	protected native void dragEnterEvent( QDragEnterEvent ev);
	protected native void dropEvent( QDropEvent ev);
	public static final int Foreground = 0;
	public static final int Background = 1;
}
