package org.kde.koala;
import org.kde.qt.*;


/** {@link KDockWidget} emits these signals */
public interface KDockWidgetSignals {

/** 
 Signals that the dock default position is set.
   
*/
	void setDockDefaultPos();
	void destroyed( QObject obj );

/** 
 Emitted when the close button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerCloseButtonClicked();

/** 
 Emitted when another dock widget is docking to this.

*/
	void docking( KDockWidget dw, int dp );

/** 
 Emitted when the widget processes a close event.
   
*/
	void iMBeingClosed();

/** 
 Emitted when the dockback button of the panel ({@link KDockWidgetHeader}) has been clicked.
   
*/
	void headerDockbackButtonClicked();

/** 
 Emitted when the widget has undocked.
   
*/
	void hasUndocked();
}

