package org.kde.koala;
import org.kde.qt.*;


/** Override these methods in subclasses of {@link KAboutApplication} to customise event handling behaviour */
public interface KAboutApplicationEventHandling {

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
	void keyPressEvent(QKeyEvent e);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void tabletEvent(QTabletEvent arg1);
	void showEvent(QShowEvent arg1);
	void contextMenuEvent(QContextMenuEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void imComposeEvent(QIMEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void imEndEvent(QIMEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);

/** 
 Emits the {@link hidden} signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
	void hideEvent(QHideEvent arg1);
	void imStartEvent(QIMEvent arg1);

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard {@link QDialog} behavior
 will take place.
     
*/
	void closeEvent(QCloseEvent e);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent arg1);
}

