/***************************************************************************
                            kde_VoiceManager.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_VOICEMANAGER
#define KDE_VOICEMANAGER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 Manages the voices used by synthesizers.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Manages internally the voices used by synth devices.

*/

/** 
 Cronstructor.
     
*/
kde_VoiceManager * kde_new_VoiceManager(int totalvoices);

/** 
 Destructor.
     
*/
void kde_del_VoiceManager( kde_VoiceManager* p );

/** 
 Allocates a voice used in channel @p chn, and playing key @p key

*/
int kde_VoiceManager_allocateVoice(kde_VoiceManager* instPointer,int chn, int key);

/** 
 Deallocates the voice with ID @p id.

*/
void kde_VoiceManager_deallocateVoice(kde_VoiceManager* instPointer,int identifier);

/** 
 initSearch() must be called always before @ref #search() to initialize
 internal variables.

*/
void kde_VoiceManager_initSearch(kde_VoiceManager* instPointer);

/** 
 Returns -1 if channel chn is not currently used, or a voice using
 channel @p chn if any.

 Calling search repeteadly, will return all the voices using channel 
 @p chn, and a -1 after the last one.

*/
int kde_VoiceManager_search(kde_VoiceManager* instPointer,int chn);

/** 
 This is a convenience function that differs from the above in that it also
 looks for a specific note (the second parameter)

*/
int kde_VoiceManager_search1(kde_VoiceManager* instPointer,int chn, int note);

/** 
 Returns the channel that voice @p v is using.
     
*/
int kde_VoiceManager_channel(kde_VoiceManager* instPointer,int v);

/** 
 Returns the note that voice @p v is playing.
     
*/
int kde_VoiceManager_note(kde_VoiceManager* instPointer,int v);

/** 
 Returns true or false if the voice @p v is being used or not respectively.
     
*/
int kde_VoiceManager_used(kde_VoiceManager* instPointer,int v);

/** 
 Clears the lists of used voices.
     
*/
void kde_VoiceManager_clearLists(kde_VoiceManager* instPointer);

#endif
