/***************************************************************************
                            kde_Slave.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_SLAVEINTERFACE
#define KDE_SLAVEINTERFACE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 There are two classes that specifies the protocol between application (job)
 and kioslave. SlaveInterface is the class to use on the application end,
 SlaveBase is the one to use on the slave end.

 A call to foo() results in a call to slotFoo() on the other end.
 
 @short 
 There are two classes that specifies the protocol between application (job)
 and kioslave.
*/
kde_Slave * kde_new_Slave(kde_Connection* connection);
void kde_del_Slave( kde_Slave* p );
void kde_Slave_setConnection(kde_Slave* instPointer,kde_Connection* connection);
kde_Connection* kde_Slave_connection(kde_Slave* instPointer);
void kde_Slave_setProgressId(kde_Slave* instPointer,int identifier);
int kde_Slave_progressId(kde_Slave* instPointer);
void kde_Slave_sendResumeAnswer(kde_Slave* instPointer,int resume);
int kde_Slave_dispatch(kde_Slave* instPointer);
int kde_Slave_dispatch1(kde_Slave* instPointer,int _cmd, qt_QByteArray* data);

/** 
 Prompt the user for authrization info (login & password).

 Use this function to request authorization info from the
 the end user. For example to open an empty password dialog
 using default values:

 <pre>
 KIO::AuthInfo authInfo;
 bool result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.latin1() );
    printf( "Username: %s", result.username.latin1() );
 }
 </pre>

 You can also pre-set some values like the username before hand
 if it is known as well as the comment and caption to be displayed:

 <pre>
 authInfo.comment= "Enter username and password to access acmeone";
 authInfo.caption= "Acme Password Dialog";
 authInfo.username= "Wily E. kaiody";
 bool result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.latin1() );
    printf( "Username: %s", result.username.latin1() );
 }
 </pre>

 NOTE: A call to this function can also fail and result
 in a return value of @p false, if the UIServer could not
 be started for whatever reason.

*/
void kde_Slave_openPassDlg(kde_Slave* instPointer,kde_AuthInfo* info);

/** 
 Same as above except in the argument it accepts.

    
*/
void kde_Slave_openPassDlg1(kde_Slave* instPointer,qt_QString * prompt, qt_QString * user, qt_QString * caption, qt_QString * comment, qt_QString * label, int readOnly);

/** 
 Same as above except in the argument it accepts.

    
*/
void kde_Slave_openPassDlg2(kde_Slave* instPointer,qt_QString * prompt, qt_QString * user, int readOnly);
void kde_Slave_messageBox(kde_Slave* instPointer,int type, qt_QString * text, qt_QString * caption, qt_QString * buttonYes, qt_QString * buttonNo);
void kde_Slave_requestNetwork(kde_Slave* instPointer,qt_QString * arg1, qt_QString * arg2);
void kde_Slave_dropNetwork(kde_Slave* instPointer,qt_QString * arg1, qt_QString * arg2);

/** 

     
*/
void kde_Slave_sigpipe_handler( int arg1);

#endif
