/***************************************************************************
                            kde_KURIFilterPlugin.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KURIFILTERPLUGIN
#define KDE_KURIFILTERPLUGIN

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Base class for URI filter plugins.

 This class applies a single filter to a URI.  All
 plugins designed to provide URI filtering functionalities
 should inherit from this abstract class and provide a
 specific filtering implementation.

 All inheriting classes need to implement the pure
 virtual function @ref filterURI.  Otherwise, they
 would also become abstract.

 @short Abstract class for URI filter plugins.
 
*/

/** 
 Returns the filter's name.

*/
qt_QString * kde_KURIFilterPlugin_name(kde_KURIFilterPlugin* instPointer);

/** 
 Returns the filter's priority.

 Each filter has an assigned priority, a float from 0 to 1. Filters
 with the lowest priority are first given a chance to filter a URI.

*/
double kde_KURIFilterPlugin_priority(kde_KURIFilterPlugin* instPointer);

/** 
 Filters a URI.

*/
int kde_KURIFilterPlugin_filterURI(kde_KURIFilterPlugin* instPointer,kde_KURIFilterData* data);

/** 
 Creates a configuration module for the filter.

 It is the responsability of the caller to delete the module
 once it is not needed anymore.

*/
kde_KCModule* kde_KURIFilterPlugin_configModule(kde_KURIFilterPlugin* instPointer,qt_QWidget * arg1, char* arg2);

/** 
 Returns the name of the configuration module for the filter.

*/
qt_QString * kde_KURIFilterPlugin_configName(kde_KURIFilterPlugin* instPointer);

#endif
