/***************************************************************************
                            kde_KJanusWidget.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KJANUSWIDGET
#define KDE_KJANUSWIDGET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Provides a number of ready to use layouts (faces). It is used
 as an internal widget in @ref KDialogBase, but can also used as a
 widget of its own.

 It provides TreeList, IconList, Tabbed, Plain and Swallow layouts.

 The TreeList face provides a list in the left area and pages in the
 right. The area are separated by a movable splitter. The style is somewhat
 similar to the layout in the Control Center. A page is raised by
 selecting the corresponding tree list item.

 The IconList face provides an icon list in the left area and pages in the
 right. For each entry the Icon is on top with the text below. The style
 is somewhat similar to the layout of the Eudora configuation dialog box.
 A page is raised by selecting the corresponding icon list item. The
 preferred icon size is 32x32 pixels.

 The Tabbed face is a common tabbed widget. The procedure for creating a
 page is similar for creating a TreeList. This has the advantage that if
 your widget contain too many pages it is trivial to convert it into a
 TreeList. Just change the face in the KJanusWidget constructor to
 KJanusWidget::TreeList and you have a tree list layout instead.

 The Plain face provides an empty widget (QFrame) where you can place your
 widgets. The KJanusWidget makes no assumptions regarding the contents so
 you are free to add whatever you want.

 The Swallow face is provided in order to simplify the usage of existing
 widgets and to allow changing the visible widget. You specify the widget
 to be displayed by @ref #setSwallowedWidget(). Your widget will be
 reparented inside the widget. You can specify a Null (0) widget. A empty
 space is then displayed.

 For all modes it is important that you specify the @ref QWidget::minimumSize()
 on the page, plain widget or the swallowed widget. If you use a QLayout
 on the page, plain widget or the swallowed widget this will be taken care
 of automatically. The size is used when the KJanusWidget determines its
 own minimum size. You get the minimum size by using the
 @ref #minimumSizeHint() or @ref #sizeHint() methods.

 Pages that have been added in TreeList, IconList or Tabbed mode can be
 removed by simply deleting the page.

 @author Espen Sand (espen@kde.org)
 
 @short Easy to use widget with many layouts.
*/
#define KJANUSWIDGET_TreeList	0
#define KJANUSWIDGET_Tabbed	0
#define KJANUSWIDGET_Plain	1
#define KJANUSWIDGET_Swallow	2
#define KJANUSWIDGET_IconList	3

/** 
 Constructor where you specify the face.

*/
kde_KJanusWidget * kde_new_KJanusWidget(qt_QWidget * parent, char* name, int face);

/** 
 Destructor.
     
*/
void kde_del_KJanusWidget( kde_KJanusWidget* p );

/** 
 Raises the page which was added by @ref addPage().

*/
int kde_KJanusWidget_showPage(kde_KJanusWidget* instPointer,int index);

/** 
 Returns the index of the page that are currently displayed.

*/
int kde_KJanusWidget_activePageIndex(kde_KJanusWidget* instPointer);

/** 
 Use this to verify
 that no memory allocation failed.

*/
int kde_KJanusWidget_isValid(kde_KJanusWidget* instPointer);

/** 
 Returns the face type.

*/
int kde_KJanusWidget_face(kde_KJanusWidget* instPointer);

/** 
 Returns the minimum size that must be made available for the widget
 so that UIs can be displayed properly

*/
qt_QSize * kde_KJanusWidget_minimumSizeHint(kde_KJanusWidget* instPointer);

/** 
 Returns the recommended size for the widget in order to be displayed
 properly.

*/
qt_QSize * kde_KJanusWidget_sizeHint(kde_KJanusWidget* instPointer);

/** 
 Returns the empty widget that is available in Plain mode.

*/
qt_QFrame* kde_KJanusWidget_plainPage(kde_KJanusWidget* instPointer);

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. In most cases you must create a layout
 manager and associate it with this widget as well.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QFrame* kde_KJanusWidget_addPage(kde_KJanusWidget* instPointer,qt_QString * item, qt_QString * header, qt_QPixmap * pixmap);

/** 
 This is like addPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.
 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QFrame* kde_KJanusWidget_addPage1(kde_KJanusWidget* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QVBox
 so it contains a QVBoxLayout layout that lines up the child widgets
 are vertically.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QVBox* kde_KJanusWidget_addVBoxPage(kde_KJanusWidget* instPointer,qt_QString * item, qt_QString * header, qt_QPixmap * pixmap);

/** 
 This is like addVBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QVBox* kde_KJanusWidget_addVBoxPage1(kde_KJanusWidget* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QHBox
 so it contains a QHBoxLayout layout that lines up the child widgets
 are horizontally.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QHBox* kde_KJanusWidget_addHBoxPage(kde_KJanusWidget* instPointer,qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** 
 This is like addHBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QHBox* kde_KJanusWidget_addHBoxPage1(kde_KJanusWidget* instPointer,qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** 
 Add a new page when the class is used in either TreeList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a @ref QGrid
 so it contains a QGridLayout layout that places up the child widgets
 in a grid.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QGrid* kde_KJanusWidget_addGridPage(kde_KJanusWidget* instPointer,int n, int dir, qt_QString * itemName, qt_QString * header, qt_QPixmap * pixmap);

/** 
 This is like addGridPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
qt_QGrid* kde_KJanusWidget_addGridPage1(kde_KJanusWidget* instPointer,int n, int dir, qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);

/** 
 Returns the index of a page created with @ref addPage ,
 @ref addVBoxPage , @ref addHBoxPage or @ref addGridPage .
 You can can compare this index with the value returned from
 @ref activePageIndex if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
int kde_KJanusWidget_pageIndex(kde_KJanusWidget* instPointer,qt_QWidget * widget);

/** 
 Defines the widget to be swallowed.

 This method can be used several
 times. Only the latest defined widget will be shown.

*/
int kde_KJanusWidget_setSwallowedWidget(kde_KJanusWidget* instPointer,qt_QWidget * widget);

/** 
 This function has only effect in TreeList mode.

 Defines how the tree list is resized when the widget is resized
 horizontally. By default the tree list keeps its width when the
 widget becomes wider.

*/
void kde_KJanusWidget_setTreeListAutoResize(kde_KJanusWidget* instPointer,int state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the @ref addPage,
 @ref addVBoxPage, @ref addHBoxPage, or @ref addGridPage methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
void kde_KJanusWidget_setShowIconsInTreeList(kde_KJanusWidget* instPointer,int state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see @ref QListView::setRootIsDecorated

*/
void kde_KJanusWidget_setRootIsDecorated(kde_KJanusWidget* instPointer,int state);

/** 
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the pages that decide the minimum height
 of the toplevel widget. A vertical scrollbar can be used in
 the icon list area.

*/
void kde_KJanusWidget_setIconListAllVisible(kde_KJanusWidget* instPointer,int state);

/** 
 Sets the icon used in TreeList Mode for the given path.

*/
void kde_KJanusWidget_setFolderIcon(kde_KJanusWidget* instPointer,qt_QStringList* path, qt_QPixmap * pixmap);

/** 
 Give the keyboard input focus to the widget.
     
*/
void kde_KJanusWidget_setFocus(kde_KJanusWidget* instPointer);

/** 
 Reimplemented to handle the splitter width when the the face
 is TreeList
     
*/

/** 
 This function is used internally when in IconList mode. If you
 reimplement this class a make your own event filter, make sure to
 call this function from your filter.

*/
int kde_KJanusWidget_eventFilter(kde_KJanusWidget* instPointer,qt_QObject * o, qt_QEvent * e);
int kde_KJanusWidget_showPage1(kde_KJanusWidget* instPointer,qt_QWidget * w);
void kde_KJanusWidget_addPageWidget(kde_KJanusWidget* instPointer,qt_QFrame* page, qt_QStringList* items, qt_QString * header, qt_QPixmap * pixmap);
void kde_KJanusWidget_InsertTreeListItem(kde_KJanusWidget* instPointer,qt_QStringList* items, qt_QPixmap * pixmap, qt_QFrame* page);
qt_QWidget * kde_KJanusWidget_FindParent(kde_KJanusWidget* instPointer);

#endif
